/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.security.access.control;

import com.liferay.portal.kernel.internal.security.access.control.AllowedIPAddressesValidator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class AllowedIPAddressesValidatorFactory {
    private static final AllowedIPAddressesValidator _ALLOWED_IP_ADDRESSES_VALIDATOR = ipAddress -> false;
    private static final int[] _BYTE = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};
    private static final Log _log = LogFactoryUtil.getLog(AllowedIPAddressesValidatorFactory.class);

    public static AllowedIPAddressesValidator create(String ipAddressAndNetmaskString) {
        if (Validator.isNull(ipAddressAndNetmaskString)) {
            return _ALLOWED_IP_ADDRESSES_VALIDATOR;
        }
        String[] ipAddressAndNetmask = StringUtil.split(ipAddressAndNetmaskString, "/");
        try {
            if (Validator.isIPv4Address(ipAddressAndNetmask[0])) {
                return new V4AllowedIPAddressesValidator(InetAddressUtil.getInetAddressByName(ipAddressAndNetmask[0]), ipAddressAndNetmask);
            }
            if (Validator.isIPv6Address(ipAddressAndNetmask[0])) {
                return new V6AllowedIPAddressesValidator(InetAddressUtil.getInetAddressByName(ipAddressAndNetmask[0]), ipAddressAndNetmask);
            }
            return _ALLOWED_IP_ADDRESSES_VALIDATOR;
        }
        catch (Exception exception) {
            _log.error("Invalid configured address: ", exception);
            return _ALLOWED_IP_ADDRESSES_VALIDATOR;
        }
    }

    private static class V6AllowedIPAddressesValidator
    extends BaseAllowedIPAddressesValidator {
        @Override
        public byte[] getEmptyNetmask() {
            return new byte[16];
        }

        private V6AllowedIPAddressesValidator(InetAddress inetAddress, String[] ipAddressAndNetmask) throws UnknownHostException {
            super(inetAddress, ipAddressAndNetmask);
        }
    }

    private static class V4AllowedIPAddressesValidator
    extends BaseAllowedIPAddressesValidator {
        @Override
        public byte[] getEmptyNetmask() {
            return new byte[4];
        }

        private V4AllowedIPAddressesValidator(InetAddress inetAddress, String[] ipAddressAndNetmask) throws UnknownHostException {
            super(inetAddress, ipAddressAndNetmask);
        }
    }

    private static abstract class BaseAllowedIPAddressesValidator
    implements AllowedIPAddressesValidator {
        private final InetAddress _allowedIpAddress;
        private final byte[] _allowedIpAddressBytes;
        private byte[] _netmask;

        @Override
        public boolean isAllowedIPAddress(String ipAddress) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddressUtil.getInetAddressByName(ipAddress);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
            byte[] inetAddressBytes = inetAddress.getAddress();
            if (!this.isSameProtocol(inetAddressBytes)) {
                return false;
            }
            if (this._netmask == null) {
                return this._allowedIpAddress.equals(inetAddress);
            }
            for (int i = 0; i < this._netmask.length; ++i) {
                if ((inetAddressBytes[i] & this._netmask[i]) == (this._allowedIpAddressBytes[i] & this._netmask[i])) continue;
                return false;
            }
            return true;
        }

        protected abstract byte[] getEmptyNetmask();

        protected boolean isSameProtocol(byte[] ipAddressBytes) {
            return this._allowedIpAddressBytes.length == ipAddressBytes.length;
        }

        private BaseAllowedIPAddressesValidator(InetAddress inetAddress, String[] ipAddressAndNetmask) throws UnknownHostException {
            this._allowedIpAddress = inetAddress;
            this._allowedIpAddressBytes = this._allowedIpAddress.getAddress();
            if (this._hasNetmask(ipAddressAndNetmask)) {
                String netmask = GetterUtil.getString(ipAddressAndNetmask[1]);
                this._netmask = Validator.isNumber(netmask) ? this._getNetmaskFromCIDR(netmask) : this._getNetmaskFromDotNotation(netmask);
            }
        }

        private byte[] _getNetmaskFromCIDR(String netmask) {
            int cidr = GetterUtil.getInteger(netmask);
            int netmaskBytes = cidr / 8;
            byte[] bytesNetmask = this.getEmptyNetmask();
            for (int i = 0; i < netmaskBytes; ++i) {
                bytesNetmask[i] = (byte)_BYTE[8];
            }
            if (netmaskBytes < bytesNetmask.length) {
                bytesNetmask[netmaskBytes] = (byte)_BYTE[cidr % 8];
            }
            return bytesNetmask;
        }

        private byte[] _getNetmaskFromDotNotation(String netmask) throws UnknownHostException {
            InetAddress inetAddress = InetAddressUtil.getInetAddressByName(netmask);
            return inetAddress.getAddress();
        }

        private boolean _hasNetmask(String[] ipAddressAndNetmask) {
            return ipAddressAndNetmask.length > 1;
        }
    }
}

