/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jsonwebservice;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

public class JSONWebServiceNaming {
    protected Set<String> excludedMethodNames = SetUtil.fromArray(PropsUtil.getArray("json.service.invalid.method.names"));
    protected String[] excludedPaths = PropsUtil.getArray("jsonws.web.service.paths.excludes");
    protected String[] excludedTypesNames = new String[]{InputStream.class.getName(), OutputStream.class.getName(), "javax."};
    protected String[] includedPaths = PropsUtil.getArray("jsonws.web.service.paths.includes");
    protected Set<String> invalidHttpMethods = SetUtil.fromArray(PropsUtil.getArray("jsonws.web.service.invalid.http.methods"));
    protected Set<String> prefixes = SetUtil.fromArray(new String[]{"get", "has", "is"});

    public String convertMethodToHttpMethod(Method method) {
        String methodName = method.getName();
        if (this.prefixes.contains(this.getMethodNamePrefix(methodName))) {
            return "GET";
        }
        return "POST";
    }

    public String convertMethodToPath(Method method) {
        return CamelCaseUtil.fromCamelCase(method.getName());
    }

    public String convertModelClassToImplClassName(Class<?> clazz) {
        ImplementationClassName implementationClassName = clazz.getAnnotation(ImplementationClassName.class);
        if (implementationClassName != null) {
            return implementationClassName.value();
        }
        String className = clazz.getName();
        className = StringUtil.replace(className, ".kernel.", ".");
        className = StringUtil.replace(className, ".model.", ".model.impl.") + "Impl";
        return className;
    }

    public String convertServiceClassToPath(Class<?> clazz) {
        String className = this.convertServiceClassToSimpleName(clazz);
        return StringUtil.toLowerCase(className);
    }

    public String convertServiceClassToSimpleName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        className = StringUtil.removeSubstring(className, "Impl");
        className = StringUtil.removeSubstring(className, "Service");
        return className;
    }

    public String convertServiceImplClassToUtilClassName(Class<?> clazz) {
        String className = clazz.getName();
        if (className.endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        return StringUtil.replace(className + "Util", ".impl.", ".");
    }

    public boolean isIncludedMethod(Method method) {
        if (this.excludedMethodNames != null && this.excludedMethodNames.contains(method.getName())) {
            return false;
        }
        if (this.excludedTypesNames == null) {
            return true;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            returnType = returnType.getComponentType();
        }
        String returnTypeName = returnType.getName();
        for (String excludedTypesName : this.excludedTypesNames) {
            if (!excludedTypesName.startsWith(returnTypeName)) continue;
            return false;
        }
        Type[] types = method.getGenericParameterTypes();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = types[i];
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.isArray()) {
                parameterType = parameterType.getComponentType();
            }
            String parameterTypeName = parameterType.getName();
            for (String excludedTypesName : this.excludedTypesNames) {
                if (parameterTypeName.startsWith(excludedTypesName)) {
                    return false;
                }
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                    String typeName = actualTypeArgument.getTypeName();
                    if (!typeName.startsWith(excludedTypesName)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isIncludedPath(String contextPath, String path) {
        String portalContextPath = PortalUtil.getPathContext();
        if (!contextPath.equals(portalContextPath)) {
            path = contextPath + "." + path.substring(1);
        }
        for (String excludedPath : this.excludedPaths) {
            if (!StringUtil.wildcardMatches(path, excludedPath, '?', '*', '\\', false)) continue;
            return false;
        }
        if (this.includedPaths.length == 0) {
            return true;
        }
        for (String includedPath : this.includedPaths) {
            if (!StringUtil.wildcardMatches(path, includedPath, '?', '*', '\\', false)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidHttpMethod(String httpMethod) {
        return !this.invalidHttpMethods.contains(httpMethod);
    }

    protected String getMethodNamePrefix(String methodName) {
        int i;
        for (i = 0; i < methodName.length() && !Character.isUpperCase(methodName.charAt(i)); ++i) {
        }
        return methodName.substring(0, i);
    }
}

