/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.license.messaging;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.messaging.LCSPortletState;
import com.liferay.portal.kernel.messaging.Message;

public enum LicenseManagerMessageType {
    LCS_AVAILABLE,
    SUBSCRIPTION_VALID,
    VALIDATE_LCS,
    VALIDATE_SUBSCRIPTION;

    public static String MESSAGE_BUS_DESTINATION_REQUEST;
    public static String MESSAGE_BUS_DESTINATION_STATUS;

    @Deprecated
    public static JSONObject getMessagePayload(Message message) {
        return LicenseManagerMessageType.getMessagePayload(message.getPayload());
    }

    @Deprecated
    public static JSONObject getMessagePayload(Object object) {
        if (object instanceof String) {
            return LicenseManagerMessageType.getMessagePayload((String)object);
        }
        return null;
    }

    @Deprecated
    public static JSONObject getMessagePayload(String json) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(json);
            LicenseManagerMessageType.valueOf(jsonObject);
            return jsonObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static LicenseManagerMessageType valueOf(JSONObject jsonObject) {
        String type = jsonObject.getString("type");
        return LicenseManagerMessageType.valueOf(type);
    }

    public Message createMessage() {
        Message message = new Message();
        message.setDestinationName(this.getDestinationName());
        message.setPayload(String.format("{\"type\": \"%s\"}", this.name()));
        return message;
    }

    public Message createMessage(LCSPortletState lcsPortletState) {
        Message message = new Message();
        message.setDestinationName(this.getDestinationName());
        message.setPayload(String.format("{\"state\": %d, \"type\": \"%s\"}", lcsPortletState.intValue(), this.name()));
        return message;
    }

    public String getDestinationName() {
        if (this == LCS_AVAILABLE || this == SUBSCRIPTION_VALID) {
            return MESSAGE_BUS_DESTINATION_STATUS;
        }
        if (this == VALIDATE_LCS || this == VALIDATE_SUBSCRIPTION) {
            return MESSAGE_BUS_DESTINATION_REQUEST;
        }
        return null;
    }

    static {
        MESSAGE_BUS_DESTINATION_REQUEST = "liferay/lcs_request";
        MESSAGE_BUS_DESTINATION_STATUS = "liferay/lcs_status";
    }
}

