/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;

public abstract class BaseMessageStatusMessageListener
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(BaseMessageStatusMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) {
        MessageStatus messageStatus = new MessageStatus();
        messageStatus.startTimer();
        try {
            this.doReceive(message, messageStatus);
        }
        catch (Exception exception) {
            _log.error("Unable to process request " + message.getDestinationName(), exception);
            messageStatus.setException(exception);
        }
        finally {
            messageStatus.stopTimer();
            message = new Message();
            message.setPayload(messageStatus);
            Destination destination = this.getDestination();
            destination.send(message);
        }
    }

    @Deprecated
    public void setStatusSender(SingleDestinationMessageSender statusSender) {
    }

    protected abstract void doReceive(Message var1, MessageStatus var2) throws Exception;

    protected abstract Destination getDestination();
}

