/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.ChannelContext;
import com.liferay.portal.kernel.nio.intraband.ClosedIntrabandException;
import com.liferay.portal.kernel.nio.intraband.CompletionHandler;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.DatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BaseIntraband
implements Intraband {
    protected static final EnumSet<CompletionHandler.CompletionType> REPLIED_ENUM_SET = EnumSet.of(CompletionHandler.CompletionType.REPLIED);
    protected final AtomicReference<DatagramReceiveHandler[]> datagramReceiveHandlersReference = new AtomicReference<DatagramReceiveHandler[]>(new DatagramReceiveHandler[256]);
    protected final long defaultTimeout;
    protected volatile boolean open = true;
    protected final Map<Long, Datagram> responseWaitingMap = new ConcurrentHashMap<Long, Datagram>();
    protected final AtomicLong sequenceIdGenerator = new AtomicLong();
    protected final NavigableMap<Long, Long> timeoutMap = new ConcurrentSkipListMap<Long, Long>();
    private static final Log _log = LogFactoryUtil.getLog(BaseIntraband.class);

    public BaseIntraband(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public void close() throws InterruptedException, IOException {
        this.datagramReceiveHandlersReference.set(null);
        this.open = false;
    }

    @Override
    public DatagramReceiveHandler[] getDatagramReceiveHandlers() {
        this.ensureOpen();
        DatagramReceiveHandler[] datagramReceiveHandlers = this.datagramReceiveHandlersReference.get();
        return (DatagramReceiveHandler[])datagramReceiveHandlers.clone();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public DatagramReceiveHandler registerDatagramReceiveHandler(byte type, DatagramReceiveHandler datagramReceiveHandler) {
        this.ensureOpen();
        int index = type & 0xFF;
        DatagramReceiveHandler oldDatagramReceiveHandler = null;
        DatagramReceiveHandler[] datagramReceiveHandlers = null;
        DatagramReceiveHandler[] copyDatagramReceiveHandlers = null;
        do {
            datagramReceiveHandlers = this.datagramReceiveHandlersReference.get();
            copyDatagramReceiveHandlers = (DatagramReceiveHandler[])datagramReceiveHandlers.clone();
            oldDatagramReceiveHandler = copyDatagramReceiveHandlers[index];
            copyDatagramReceiveHandlers[index] = datagramReceiveHandler;
        } while (!this.datagramReceiveHandlersReference.compareAndSet(datagramReceiveHandlers, copyDatagramReceiveHandlers));
        return oldDatagramReceiveHandler;
    }

    @Override
    public void sendDatagram(RegistrationReference registrationReference, Datagram datagram) {
        if (registrationReference == null) {
            throw new NullPointerException("Registration reference is null");
        }
        if (!registrationReference.isValid()) {
            throw new IllegalArgumentException("Registration reference is invalid");
        }
        if (datagram == null) {
            throw new NullPointerException("Datagram is null");
        }
        this.ensureOpen();
        this.doSendDatagram(registrationReference, datagram);
    }

    @Override
    public <A> void sendDatagram(RegistrationReference registrationReference, Datagram datagram, A attachment, EnumSet<CompletionHandler.CompletionType> completionTypes, CompletionHandler<A> completionHandler) {
        this.sendDatagram(registrationReference, datagram, attachment, completionTypes, completionHandler, this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public <A> void sendDatagram(RegistrationReference registrationReference, Datagram datagram, A attachment, EnumSet<CompletionHandler.CompletionType> completionTypes, CompletionHandler<A> completionHandler, long timeout, TimeUnit timeUnit) {
        if (registrationReference == null) {
            throw new NullPointerException("Registration reference is null");
        }
        if (!registrationReference.isValid()) {
            throw new IllegalArgumentException("Registration reference is invalid");
        }
        if (datagram == null) {
            throw new NullPointerException("Datagram is null");
        }
        if (completionTypes == null) {
            throw new NullPointerException("Completion type set is null");
        }
        if (completionTypes.isEmpty()) {
            throw new IllegalArgumentException("Completion type set is empty");
        }
        if (completionHandler == null) {
            throw new NullPointerException("Complete handler is null");
        }
        if (timeUnit == null) {
            throw new NullPointerException("Time unit is null");
        }
        timeout = timeout <= 0L ? this.defaultTimeout : timeUnit.toMillis(timeout);
        this.ensureOpen();
        datagram.attachment = attachment;
        datagram.completionHandler = completionHandler;
        datagram.completionTypes = completionTypes;
        datagram.timeout = timeout;
        datagram.setAckRequest(completionTypes.contains((Object)CompletionHandler.CompletionType.DELIVERED));
        if (datagram.getSequenceId() == 0L) {
            datagram.setSequenceId(this.generateSequenceId());
        }
        if (completionTypes.contains((Object)CompletionHandler.CompletionType.DELIVERED) || completionTypes.contains((Object)CompletionHandler.CompletionType.REPLIED)) {
            this.addResponseWaitingDatagram(datagram);
        }
        this.doSendDatagram(registrationReference, datagram);
    }

    @Override
    public Datagram sendSyncDatagram(RegistrationReference registrationReference, Datagram datagram) throws InterruptedException, IOException, TimeoutException {
        return this.sendSyncDatagram(registrationReference, datagram, this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Datagram sendSyncDatagram(RegistrationReference registrationReference, Datagram datagram, long timeout, TimeUnit timeUnit) throws InterruptedException, IOException, TimeoutException {
        if (registrationReference == null) {
            throw new NullPointerException("Registration reference is null");
        }
        if (!registrationReference.isValid()) {
            throw new IllegalArgumentException("Registration reference is invalid");
        }
        if (datagram == null) {
            throw new NullPointerException("Datagram is null");
        }
        if (timeUnit == null) {
            throw new NullPointerException("Time unit is null");
        }
        timeout = timeout <= 0L ? this.defaultTimeout : timeUnit.toMillis(timeout);
        this.ensureOpen();
        return this.doSendSyncDatagram(registrationReference, datagram, timeout);
    }

    @Override
    public DatagramReceiveHandler unregisterDatagramReceiveHandler(byte type) {
        return this.registerDatagramReceiveHandler(type, null);
    }

    protected void addResponseWaitingDatagram(Datagram requestDatagram) {
        long expireTime;
        long sequenceId = requestDatagram.getSequenceId();
        requestDatagram.expireTime = expireTime = System.currentTimeMillis() + requestDatagram.timeout;
        this.responseWaitingMap.put(sequenceId, requestDatagram);
        this.timeoutMap.put(expireTime, sequenceId);
    }

    protected void cleanUpTimeoutResponseWaitingDatagrams() {
        NavigableMap<Long, Long> map = this.timeoutMap.headMap(System.currentTimeMillis(), true);
        if (map.isEmpty()) {
            return;
        }
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            iterator.remove();
            Long sequenceId = (Long)entry.getValue();
            Datagram datagram = this.responseWaitingMap.remove(sequenceId);
            if (_log.isWarnEnabled()) {
                _log.warn("Removed timeout response waiting datagram " + datagram);
            }
            datagram.completionHandler.timedOut(datagram.attachment);
        }
    }

    protected abstract void doSendDatagram(RegistrationReference var1, Datagram var2);

    protected Datagram doSendSyncDatagram(RegistrationReference registrationReference, Datagram datagram, long timeout) throws InterruptedException, IOException, TimeoutException {
        SendSyncDatagramCompletionHandler sendSyncDatagramCompletionHandler;
        datagram.completionHandler = sendSyncDatagramCompletionHandler = new SendSyncDatagramCompletionHandler();
        datagram.completionTypes = REPLIED_ENUM_SET;
        datagram.timeout = timeout;
        if (datagram.getSequenceId() == 0L) {
            datagram.setSequenceId(this.generateSequenceId());
        }
        this.addResponseWaitingDatagram(datagram);
        this.doSendDatagram(registrationReference, datagram);
        return sendSyncDatagramCompletionHandler.waitResult(timeout);
    }

    protected void ensureOpen() {
        if (!this.isOpen()) {
            throw new ClosedIntrabandException();
        }
    }

    protected long generateSequenceId() {
        long sequenceId = this.sequenceIdGenerator.getAndIncrement();
        if (sequenceId < 0L) {
            sequenceId += Long.MIN_VALUE;
        }
        return sequenceId;
    }

    protected void handleReading(ScatteringByteChannel scatteringByteChannel, ChannelContext channelContext) {
        block24: {
            Datagram datagram = channelContext.getReadingDatagram();
            if (datagram == null) {
                datagram = Datagram.createReceiveDatagram();
                channelContext.setReadingDatagram(datagram);
            }
            try {
                if (datagram.readFrom(scatteringByteChannel)) {
                    channelContext.setReadingDatagram(Datagram.createReceiveDatagram());
                    if (datagram.isAckResponse()) {
                        Datagram requestDatagram = this.removeResponseWaitingDatagram(datagram);
                        if (requestDatagram == null) {
                            if (_log.isWarnEnabled()) {
                                _log.warn("Dropped ownerless ACK response " + datagram);
                            }
                        } else {
                            CompletionHandler<Object> completionHandler = requestDatagram.completionHandler;
                            completionHandler.delivered(requestDatagram.attachment);
                        }
                    } else if (datagram.isResponse()) {
                        Datagram requestDatagram = this.removeResponseWaitingDatagram(datagram);
                        if (requestDatagram == null) {
                            if (_log.isWarnEnabled()) {
                                _log.warn("Dropped ownerless response " + datagram);
                            }
                        } else {
                            EnumSet<CompletionHandler.CompletionType> completionTypes = requestDatagram.completionTypes;
                            if (completionTypes.contains((Object)CompletionHandler.CompletionType.REPLIED)) {
                                CompletionHandler<Object> completionHandler = requestDatagram.completionHandler;
                                completionHandler.replied(requestDatagram.attachment, datagram);
                            } else if (_log.isWarnEnabled()) {
                                _log.warn("Dropped unconcerned response " + datagram);
                            }
                        }
                    } else {
                        if (datagram.isAckRequest()) {
                            Datagram ackResponseDatagram = Datagram.createACKResponseDatagram(datagram.getSequenceId());
                            this.doSendDatagram(channelContext.getRegistrationReference(), ackResponseDatagram);
                        }
                        int index = datagram.getType() & 0xFF;
                        DatagramReceiveHandler datagramReceiveHandler = this.datagramReceiveHandlersReference.get()[index];
                        if (datagramReceiveHandler == null) {
                            if (_log.isWarnEnabled()) {
                                _log.warn("Dropped ownerless request " + datagram);
                            }
                        } else {
                            try {
                                datagramReceiveHandler.receive(channelContext.getRegistrationReference(), datagram);
                            }
                            catch (Throwable t) {
                                _log.error("Unable to dispatch", t);
                            }
                        }
                    }
                }
            }
            catch (IOException ioException) {
                RegistrationReference registrationReference = channelContext.getRegistrationReference();
                registrationReference.cancelRegistration();
                if (_log.isDebugEnabled()) {
                    _log.debug("Broken read channel, unregister " + registrationReference, ioException);
                }
                if (!_log.isInfoEnabled()) break block24;
                _log.info("Broken read channel, unregister " + registrationReference);
            }
        }
    }

    protected boolean handleWriting(GatheringByteChannel gatheringByteChannel, ChannelContext channelContext) {
        Datagram datagram = channelContext.getWritingDatagram();
        try {
            if (datagram.writeTo(gatheringByteChannel)) {
                channelContext.setWritingDatagram(null);
                EnumSet<CompletionHandler.CompletionType> completionTypes = datagram.completionTypes;
                if (completionTypes != null && completionTypes.contains((Object)CompletionHandler.CompletionType.SUBMITTED)) {
                    CompletionHandler<Object> completeHandler = datagram.completionHandler;
                    completeHandler.submitted(datagram.attachment);
                }
                return true;
            }
            return false;
        }
        catch (IOException ioException) {
            RegistrationReference registrationReference = channelContext.getRegistrationReference();
            registrationReference.cancelRegistration();
            CompletionHandler<Object> completionHandler = datagram.completionHandler;
            if (completionHandler != null) {
                completionHandler.failed(datagram.attachment, ioException);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Broken write channel, unregister " + registrationReference, ioException);
            } else if (_log.isInfoEnabled()) {
                _log.info("Broken write channel, unregister " + registrationReference);
            }
            return false;
        }
    }

    protected Datagram removeResponseWaitingDatagram(Datagram responseDatagram) {
        Datagram requestDatagram = this.responseWaitingMap.remove(responseDatagram.getSequenceId());
        if (requestDatagram != null) {
            this.timeoutMap.remove(requestDatagram.expireTime);
        }
        return requestDatagram;
    }

    protected static class SendSyncDatagramCompletionHandler
    implements CompletionHandler<Object> {
        private final CountDownLatch _countDownLatch = new CountDownLatch(1);
        private Datagram _datagram;
        private IOException _ioe;

        protected SendSyncDatagramCompletionHandler() {
        }

        @Override
        public void delivered(Object attachment) {
        }

        @Override
        public void failed(Object attachment, IOException ioException) {
            this._ioe = ioException;
            this._countDownLatch.countDown();
        }

        @Override
        public void replied(Object attachment, Datagram datagram) {
            this._datagram = datagram;
            this._countDownLatch.countDown();
        }

        @Override
        public void submitted(Object attachment) {
        }

        @Override
        public void timedOut(Object attachment) {
        }

        public Datagram waitResult(long timeout) throws InterruptedException, IOException, TimeoutException {
            boolean result = this._countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            if (!result) {
                throw new TimeoutException("Result waiting timeout");
            }
            if (this._ioe != null) {
                throw this._ioe;
            }
            return this._datagram;
        }
    }
}

