/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public abstract class BaseUserNotificationHandler
implements UserNotificationHandler {
    private static final String _BODY_TEMPLATE_DEFAULT = "<div class=\"title\">[$TITLE$]</div><div class=\"body\">[$BODY$]</div>";
    private static final Log _log = LogFactoryUtil.getLog(BaseUserNotificationHandler.class);
    private boolean _actionable;
    private boolean _openDialog;
    private String _portletId;
    private String _selector = "";

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public String getSelector() {
        return this._selector;
    }

    @Override
    public UserNotificationFeedEntry interpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        try {
            UserNotificationFeedEntry userNotificationFeedEntry = this.doInterpret(userNotificationEvent, serviceContext);
            if (userNotificationFeedEntry != null) {
                userNotificationFeedEntry.setOpenDialog(this.isOpenDialog());
                userNotificationFeedEntry.setPortletId(this.getPortletId());
            } else {
                Locale locale = serviceContext.getLocale();
                String portletTitle = PortalUtil.getPortletTitle(this.getPortletId(), locale);
                String body = StringUtil.replace(_BODY_TEMPLATE_DEFAULT, new String[]{"[$BODY$]", "[$TITLE$]"}, new String[]{LanguageUtil.format(locale, "notification-for-x-was-deleted", (Object)portletTitle, false), LanguageUtil.get(locale, "notification-no-longer-applies")});
                userNotificationFeedEntry = new UserNotificationFeedEntry(false, body, "", false);
            }
            return userNotificationFeedEntry;
        }
        catch (Exception exception) {
            _log.error("Unable to interpret notification", exception);
            return null;
        }
    }

    @Override
    public boolean isDeliver(long userId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException {
        UserNotificationDefinition userNotificationDefinition = UserNotificationManagerUtil.fetchUserNotificationDefinition(this._portletId, classNameId, notificationType);
        if (userNotificationDefinition == null) {
            return deliveryType == 10000;
        }
        UserNotificationDeliveryType userNotificationDeliveryType = userNotificationDefinition.getUserNotificationDeliveryType(deliveryType);
        if (userNotificationDeliveryType == null) {
            return false;
        }
        UserNotificationDelivery userNotificationDelivery = UserNotificationDeliveryLocalServiceUtil.fetchUserNotificationDelivery(userId, this._portletId, classNameId, notificationType, deliveryType);
        if (userNotificationDelivery != null) {
            return userNotificationDelivery.isDeliver();
        }
        return userNotificationDeliveryType.isDefault();
    }

    @Override
    public boolean isOpenDialog() {
        return this._openDialog;
    }

    protected UserNotificationFeedEntry doInterpret(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        String body = this.getBody(userNotificationEvent, serviceContext);
        if (Validator.isNull(body)) {
            return null;
        }
        String link = this.getLink(userNotificationEvent, serviceContext);
        boolean applicable = this.isApplicable(userNotificationEvent, serviceContext);
        return new UserNotificationFeedEntry(this.isActionable(), body, link, applicable);
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected String getBodyTemplate() throws Exception {
        if (this.isActionable()) {
            StringBundler sb = new StringBundler(7);
            sb.append("<div class=\"title\">[$TITLE$]</div><div ");
            sb.append("class=\"body\"><div class=\"button-holder\"><a ");
            sb.append("class=\"btn btn-primary ");
            sb.append("user-notification-action\" href=\"[$CONFIRM_URL$]\">");
            sb.append("[$CONFIRM$]</a><a class=\"btn btn-default ");
            sb.append("user-notification-action\" href=\"[$IGNORE_URL$]\">");
            sb.append("[$IGNORE$]</a></div></div>");
            return sb.toString();
        }
        return _BODY_TEMPLATE_DEFAULT;
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected boolean isActionable() {
        return this._actionable;
    }

    protected void setActionable(boolean actionable) {
        this._actionable = actionable;
    }

    protected void setOpenDialog(boolean openDialog) {
        this._openDialog = openDialog;
    }

    protected void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    protected void setSelector(String selector) {
        this._selector = selector;
    }
}

