/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.util.Objects;

public class NotificationEvent
implements Serializable {
    private static final String _KEY_ARCHIVED = "archived";
    private static final String _KEY_DELIVERY_BY = "deliveryBy";
    private static final String _KEY_DELIVERY_REQUIRED = "deliveryRequired";
    private static final String _KEY_DELIVERY_TYPE = "deliveryType";
    private static final String _KEY_PAYLOAD = "payload";
    private static final String _KEY_TIMESTAMP = "timestamp";
    private static final String _KEY_TYPE = "type";
    private static final String _KEY_UUID = "uuid";
    private boolean _archived;
    private long _deliverBy;
    private boolean _deliveryRequired;
    private int _deliveryType;
    private final JSONObject _payloadJSONObject;
    private long _timestamp;
    private final String _type;
    private String _uuid;

    public NotificationEvent(long timestamp, String type, JSONObject payloadJSONObject) {
        this._timestamp = timestamp;
        this._type = type;
        this._payloadJSONObject = payloadJSONObject;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NotificationEvent)) {
            return false;
        }
        NotificationEvent notificationEvent = (NotificationEvent)obj;
        return Objects.equals(this.getUuid(), notificationEvent.getUuid());
    }

    public long getDeliverBy() {
        return this._deliverBy;
    }

    public int getDeliveryType() {
        return this._deliveryType;
    }

    public JSONObject getPayload() {
        return this._payloadJSONObject;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public String getType() {
        return this._type;
    }

    public String getUuid() {
        if (this._uuid == null) {
            this._uuid = PortalUUIDUtil.generate();
        }
        return this._uuid;
    }

    public int hashCode() {
        String uuid = this.getUuid();
        return uuid.hashCode();
    }

    public boolean isArchived() {
        return this._archived;
    }

    public boolean isDeliveryRequired() {
        return this._deliveryRequired;
    }

    public void setArchived(boolean archived) {
        this._archived = archived;
    }

    public void setDeliverBy(long deliverBy) throws IllegalArgumentException {
        if (deliverBy < 0L && this._deliveryRequired) {
            throw new IllegalArgumentException("Deliver by must be greater than or equal to 0 if delivery is required");
        }
        this._deliverBy = deliverBy;
    }

    public void setDeliveryRequired(long deliverBy) throws IllegalArgumentException {
        if (deliverBy < 0L) {
            throw new IllegalArgumentException("Deliver by must be greater than or equal to 0 if delivery is required");
        }
        this._deliverBy = deliverBy;
        this._deliveryRequired = true;
    }

    public void setDeliveryType(int deliveryType) {
        this._deliveryType = deliveryType;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public JSONObject toJSONObject() {
        return JSONUtil.put(_KEY_ARCHIVED, (Object)this._archived).put(_KEY_DELIVERY_BY, this._deliverBy).put(_KEY_DELIVERY_REQUIRED, this._deliveryRequired).put(_KEY_DELIVERY_TYPE, this._deliveryType).put(_KEY_PAYLOAD, this._payloadJSONObject).put(_KEY_TIMESTAMP, this._timestamp).put(_KEY_TYPE, this._type).put(_KEY_UUID, this._uuid);
    }
}

