/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.plugin;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class Version
implements Comparable<Version>,
Serializable {
    public static final String SNAPSHOT = "SNAPSHOT";
    public static final String UNKNOWN = "unknown";
    private static final String _SEPARATOR = ".";
    private static final Map<String, Version> _versions = new ConcurrentHashMap<String, Version>();
    private String _bugFix;
    private final String _buildNumber;
    private String _major;
    private String _minor;
    private String _qualifier;

    public static Version getInstance(String version) {
        Version versionObj = _versions.get(version);
        if (versionObj == null) {
            versionObj = new Version(version);
            _versions.put(version, versionObj);
        }
        return versionObj;
    }

    public static Version incrementBugFix(Version version) {
        String bugFix = version.getBugFix();
        int bugFixInt = GetterUtil.getInteger(bugFix);
        if (bugFixInt > 0) {
            bugFix = String.valueOf(bugFixInt + 1);
        }
        return Version.getInstance(Version._toString(version.getMajor(), version.getMinor(), bugFix, version.getBuildNumber(), version.getQualifier()));
    }

    public static Version incrementBuildNumber(Version version) {
        String buildNumber = version.getBuildNumber();
        int buildNumberInt = GetterUtil.getInteger(buildNumber);
        if (buildNumberInt > 0) {
            buildNumber = String.valueOf(buildNumberInt + 1);
        }
        return Version.getInstance(Version._toString(version.getMajor(), version.getMinor(), version.getBugFix(), buildNumber, version.getQualifier()));
    }

    public static Version incrementMajor(Version version) {
        String major = version.getMajor();
        int majorInt = GetterUtil.getInteger(major);
        if (majorInt > 0) {
            major = String.valueOf(majorInt + 1);
        }
        return Version.getInstance(Version._toString(major, version.getMinor(), version.getBugFix(), version.getBuildNumber(), version.getQualifier()));
    }

    public static Version incrementMinor(Version version) {
        String minor = version.getMinor();
        int minorInt = GetterUtil.getInteger(minor);
        if (minorInt > 0) {
            minor = String.valueOf(minorInt + 1);
        }
        return Version.getInstance(Version._toString(version.getMajor(), minor, version.getBugFix(), version.getBuildNumber(), version.getQualifier()));
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        if (UNKNOWN.equals(version.toString())) {
            return 1;
        }
        if (UNKNOWN.equals(this.toString())) {
            return -1;
        }
        int result = this._compareAsIntegers(this.getMajor(), version.getMajor());
        if (result != 0) {
            return result;
        }
        result = this._compareAsIntegers(this.getMinor(), version.getMinor());
        if (result != 0) {
            return result;
        }
        result = this._compareAsIntegers(this.getBugFix(), version.getBugFix());
        if (result != 0) {
            return result;
        }
        result = this._compareAsIntegers(this.getBuildNumber(), version.getBuildNumber());
        if (result != 0) {
            return result;
        }
        return this._compareAsQualifiers(this.getQualifier(), version.getQualifier());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        String versionString1 = this.toString();
        String versionString2 = String.valueOf((Version)obj);
        if (versionString1.equals(UNKNOWN) || versionString2.equals(UNKNOWN)) {
            return false;
        }
        return versionString1.equals(versionString2);
    }

    public String getBugFix() {
        if (this._bugFix == null) {
            return "0";
        }
        return this._bugFix;
    }

    public String getBuildNumber() {
        return this._buildNumber;
    }

    public String getMajor() {
        if (this._major == null) {
            return "0";
        }
        return this._major;
    }

    public String getMinor() {
        if (this._minor == null) {
            return "0";
        }
        return this._minor;
    }

    public String getQualifier() {
        if (this._qualifier == null) {
            return "";
        }
        return this._qualifier;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean includes(Version version) {
        if (this.equals(version)) {
            return true;
        }
        if (this.getMajor().equals("*")) {
            return true;
        }
        if (this.getMajor().equals(version.getMajor())) {
            if (this.getMinor().equals("*")) {
                return true;
            }
            if (this.getMinor().equals(version.getMinor())) {
                if (this.getBugFix().equals("*")) {
                    return true;
                }
                if (this.getBugFix().equals(version.getBugFix())) {
                    if (this.getBuildNumber().equals("*") || this.getBuildNumber().equals(version.getBuildNumber())) {
                        return true;
                    }
                    if (Version._contains(this.getBuildNumber(), version.getBuildNumber())) {
                        return true;
                    }
                } else if (Version._contains(this.getBugFix(), version.getBugFix())) {
                    return true;
                }
            } else if (Version._contains(this.getMinor(), version.getMinor())) {
                return true;
            }
        } else if (Version._contains(this.getMajor(), version.getMajor())) {
            return true;
        }
        return false;
    }

    public boolean isLaterVersionThan(String version) {
        return this.compareTo(Version.getInstance(version)) > 0;
    }

    public boolean isPreviousVersionThan(String version) {
        return this.compareTo(Version.getInstance(version)) < 0;
    }

    public boolean isSameVersionAs(String version) {
        return this.compareTo(Version.getInstance(version)) == 0;
    }

    public String toString() {
        return Version._toString(this._major, this._minor, this._bugFix, this._buildNumber, this._qualifier);
    }

    protected Version(String version) {
        int index = version.indexOf(45);
        if (index != -1) {
            this._qualifier = version.substring(index + 1);
            version = version.substring(0, index);
        }
        StringTokenizer st = new StringTokenizer(version, _SEPARATOR);
        this._major = st.nextToken();
        if (st.hasMoreTokens()) {
            this._minor = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this._bugFix = st.nextToken();
        }
        this._buildNumber = st.hasMoreTokens() ? st.nextToken() : null;
    }

    private static boolean _contains(String containerString, String numberString) {
        if (containerString.endsWith("+")) {
            String containerNumberString = containerString.substring(0, containerString.length() - 1);
            try {
                int containerNumber = GetterUtil.getInteger(containerNumberString);
                int number = GetterUtil.getInteger(numberString);
                return containerNumber <= number;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private static String _toString(String major, String minor, String bugFix, String buildNumber, String qualifier) {
        StringBundler sb = new StringBundler(9);
        sb.append(major);
        if (Validator.isNotNull(minor)) {
            sb.append(_SEPARATOR);
            sb.append(minor);
            if (Validator.isNotNull(bugFix)) {
                sb.append(_SEPARATOR);
                sb.append(bugFix);
                if (Validator.isNotNull(buildNumber)) {
                    sb.append(_SEPARATOR);
                    sb.append(buildNumber);
                }
            }
        }
        if (Validator.isNotNull(qualifier)) {
            sb.append('-');
            sb.append(qualifier);
        }
        return sb.toString();
    }

    private int _compareAsIntegers(String first, String second) {
        int secondInteger;
        int firstInteger = GetterUtil.getInteger(first);
        if (firstInteger < (secondInteger = GetterUtil.getInteger(second))) {
            return -1;
        }
        if (firstInteger == secondInteger) {
            return 0;
        }
        return 1;
    }

    private int _compareAsQualifiers(String first, String second) {
        String firstString = GetterUtil.getString(first);
        String secondString = GetterUtil.getString(second);
        if (StringUtil.equalsIgnoreCase(firstString, SNAPSHOT) && !StringUtil.equalsIgnoreCase(secondString, SNAPSHOT)) {
            return -1;
        }
        if (!StringUtil.equalsIgnoreCase(firstString, SNAPSHOT) && StringUtil.equalsIgnoreCase(secondString, SNAPSHOT)) {
            return 1;
        }
        return 0;
    }
}

