/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FriendlyURLResolverRegistryUtil {
    private static final ServiceRegistrationMap<FriendlyURLResolver> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private static final ServiceTrackerMap<String, FriendlyURLResolver> _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(FriendlyURLResolver.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, FriendlyURLResolver>(){

        public void map(ServiceReference<FriendlyURLResolver> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)registry.getService(serviceReference);
            emitter.emit((Object)friendlyURLResolver.getURLSeparator());
            registry.ungetService(serviceReference);
        }
    });

    public static FriendlyURLResolver getFriendlyURLResolver(String urlSeparator) {
        return (FriendlyURLResolver)_serviceTrackerMap.getService((Object)urlSeparator);
    }

    @Deprecated
    public static List<FriendlyURLResolver> getFriendlyURLResolvers() {
        return new ArrayList<FriendlyURLResolver>(FriendlyURLResolverRegistryUtil.getFriendlyURLResolversAsCollection());
    }

    public static Collection<FriendlyURLResolver> getFriendlyURLResolversAsCollection() {
        ArrayList<FriendlyURLResolver> friendlyURLResolvers = new ArrayList<FriendlyURLResolver>();
        for (String key : _serviceTrackerMap.keySet()) {
            FriendlyURLResolver friendlyURLResolver = (FriendlyURLResolver)_serviceTrackerMap.getService((Object)key);
            if (friendlyURLResolver == null) continue;
            friendlyURLResolvers.add(friendlyURLResolver);
        }
        return friendlyURLResolvers;
    }

    public static String[] getURLSeparators() {
        Set urlSeparators = _serviceTrackerMap.keySet();
        return urlSeparators.toArray(new String[0]);
    }

    public static void register(FriendlyURLResolver friendlyURLResolver) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(FriendlyURLResolver.class, (Object)friendlyURLResolver);
        _serviceRegistrations.put((Object)friendlyURLResolver, (Object)serviceRegistration);
    }

    public static void unregister(FriendlyURLResolver friendlyURLResolver) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)_serviceRegistrations.remove((Object)friendlyURLResolver);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}

