/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.DefaultLocalRepositoryImpl;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CapabilityProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.search.RepositorySearchQueryBuilderUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.RepositoryEntryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class BaseRepositoryImpl
implements BaseRepository,
CapabilityProvider {
    protected AssetEntryLocalService assetEntryLocalService;
    protected CompanyLocalService companyLocalService;
    protected DLAppHelperLocalService dlAppHelperLocalService;
    protected DLFolderLocalService dlFolderLocalService;
    protected RepositoryEntryLocalService repositoryEntryLocalService;
    protected UserLocalService userLocalService;
    private static final String[][] _SUPPORTED_PARAMETERS = new String[0][];
    private long _companyId;
    private long _groupId;
    private final LocalRepository _localRepository = new DefaultLocalRepositoryImpl(this);
    private long _repositoryId;
    private UnicodeProperties _typeSettingsProperties;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        try (FileInputStream is = new FileInputStream(file);){
            FileEntry fileEntry = this.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, file.length(), serviceContext);
            return fileEntry;
        }
        catch (IOException ioException) {
            throw new SystemException(ioException);
        }
    }

    @Override
    public abstract Folder addFolder(long var1, long var3, String var5, String var6, ServiceContext var7) throws PortalException;

    @Override
    @Deprecated
    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.fromMajorVersion(majorVersion), changeLog, serviceContext);
    }

    @Override
    public abstract void checkInFileEntry(long var1, long var3, DLVersionNumberIncrease var5, String var6, ServiceContext var7) throws PortalException;

    @Override
    public abstract FileEntry checkOutFileEntry(long var1, ServiceContext var3) throws PortalException;

    @Override
    public abstract FileEntry checkOutFileEntry(long var1, String var3, long var4, ServiceContext var6) throws PortalException;

    @Override
    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFileEntry(long folderId, String title) throws PortalException {
        FileEntry fileEntry = this.getFileEntry(folderId, title);
        this.deleteFileEntry(fileEntry.getFileEntryId());
    }

    @Override
    public void deleteFileVersion(long fileVersionId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFileVersion(long fileEntryId, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        Folder folder = this.getFolder(parentFolderId, name);
        this.deleteFolder(folder.getFolderId());
    }

    @Override
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        throw new IllegalArgumentException(String.format("Capability %s is not supported by repository %s", capabilityClass.getName(), this.getRepositoryId()));
    }

    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return this.getFileEntries(folderId, start, end, null);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this.getFileEntriesCount(folderId);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        return this.getFileEntriesCount(folderId, mimeTypes);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this.getFolders(parentFolderId, includeMountfolders, start, end, obc);
    }

    public abstract List<Object> getFoldersAndFileEntries(long var1, int var3, int var4, OrderByComparator<?> var5);

    public abstract List<Object> getFoldersAndFileEntries(long var1, String[] var3, int var4, int var5, OrderByComparator<?> var6) throws PortalException;

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) {
        return this.getFoldersAndFileEntries(folderId, start, end, obc);
    }

    @Override
    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this.getFoldersAndFileEntries(folderId, mimeTypes, start, end, obc);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) {
        return this.getFoldersAndFileEntriesCount(folderId);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesCount(folderId, mimeTypes);
    }

    public abstract int getFoldersAndFileEntriesCount(long var1);

    public abstract int getFoldersAndFileEntriesCount(long var1, String[] var3) throws PortalException;

    @Override
    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this.getFoldersCount(parentFolderId, includeMountfolders);
    }

    public long getGroupId() {
        return this._groupId;
    }

    @Override
    public LocalRepository getLocalRepository() {
        return this._localRepository;
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this.getFileEntries(rootFolderId, start, end, obc);
    }

    @Override
    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this.getFileEntries(rootFolderId, mimeTypes, start, end, obc);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        return this.getFileEntriesCount(rootFolderId);
    }

    @Override
    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return this.getFileEntriesCount(rootFolderId, mimeTypes);
    }

    @Override
    public long getRepositoryId() {
        return this._repositoryId;
    }

    @Override
    @Deprecated
    public String[][] getSupportedParameters() {
        return _SUPPORTED_PARAMETERS;
    }

    public UnicodeProperties getTypeSettingsProperties() {
        return this._typeSettingsProperties;
    }

    @Override
    public abstract void initRepository() throws PortalException;

    @Override
    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        return false;
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        searchContext.setSearchEngineId("GENERIC_ENGINE");
        return this.search(searchContext, RepositorySearchQueryBuilderUtil.getFullQuery(searchContext));
    }

    @Override
    public void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this.assetEntryLocalService = assetEntryLocalService;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @Override
    public void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this.companyLocalService = companyLocalService;
    }

    @Override
    public void setDLAppHelperLocalService(DLAppHelperLocalService dlAppHelperLocalService) {
        this.dlAppHelperLocalService = dlAppHelperLocalService;
    }

    @Override
    public void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this.dlFolderLocalService = dlFolderLocalService;
    }

    @Override
    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    @Override
    public void setRepositoryEntryLocalService(RepositoryEntryLocalService repositoryEntryLocalService) {
        this.repositoryEntryLocalService = repositoryEntryLocalService;
    }

    @Override
    public void setRepositoryId(long repositoryId) {
        this._repositoryId = repositoryId;
    }

    @Override
    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
    }

    @Override
    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    @Override
    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        Folder folder = this.getFolder(parentFolderId, name);
        this.unlockFolder(folder.getFolderId(), lockUuid);
    }

    @Override
    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), file, serviceContext);
    }

    @Override
    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), is, size, serviceContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        try (FileInputStream is = new FileInputStream(file);){
            FileEntry fileEntry = this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, (InputStream)is, file.length(), serviceContext);
            return fileEntry;
        }
        catch (IOException ioException) {
            throw new SystemException(ioException);
        }
    }

    @Override
    public abstract FileEntry updateFileEntry(long var1, long var3, String var5, String var6, String var7, String var8, String var9, DLVersionNumberIncrease var10, InputStream var11, long var12, ServiceContext var14) throws PortalException;

    @Override
    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    protected void clearManualCheckInRequired(long fileEntryId, ServiceContext serviceContext) throws NoSuchRepositoryEntryException {
        boolean webDAVCheckInMode = GetterUtil.getBoolean(serviceContext.getAttribute("webDAVCheckInMode"));
        if (webDAVCheckInMode) {
            return;
        }
        com.liferay.portal.kernel.model.RepositoryEntry repositoryEntry = RepositoryEntryUtil.findByPrimaryKey(fileEntryId);
        boolean manualCheckInRequired = repositoryEntry.isManualCheckInRequired();
        if (!manualCheckInRequired) {
            return;
        }
        repositoryEntry.setManualCheckInRequired(false);
        RepositoryEntryUtil.update(repositoryEntry);
    }

    protected com.liferay.portal.kernel.model.RepositoryEntry getRepositoryEntry(String objectId) throws PortalException {
        return this.repositoryEntryLocalService.getRepositoryEntry(PrincipalThreadLocal.getUserId(), this.getGroupId(), this.getRepositoryId(), objectId);
    }

    protected void setManualCheckInRequired(long fileEntryId, ServiceContext serviceContext) throws NoSuchRepositoryEntryException {
        if (!GetterUtil.getBoolean(serviceContext.getAttribute("manualCheckInRequired"))) {
            return;
        }
        com.liferay.portal.kernel.model.RepositoryEntry repositoryEntry = RepositoryEntryUtil.findByPrimaryKey(fileEntryId);
        repositoryEntry.setManualCheckInRequired(true);
        RepositoryEntryUtil.update(repositoryEntry);
    }
}

