/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.agent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AcceptorServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(AcceptorServlet.class);

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PortalUtil.setPortalInetSocketAddresses(httpServletRequest);
        ServletContext servletContext = this.getServletContext();
        String uriPath = PortalUtil.getPathContext();
        if (uriPath.isEmpty()) {
            uriPath = "/";
        }
        ServletContext portalServletContext = servletContext.getContext(uriPath);
        RequestDispatcher requestDispatcher = portalServletContext.getRequestDispatcher("/c/portal/resiliency");
        SPI spi = SPIUtil.getSPI();
        SPIAgent spiAgent = spi.getSPIAgent();
        HttpServletRequest spiAgentHttpServletRequest = spiAgent.prepareRequest(httpServletRequest);
        HttpServletResponse spiAgentHttpServletResponse = spiAgent.prepareResponse(httpServletRequest, httpServletResponse);
        Exception exception1 = null;
        try {
            requestDispatcher.forward((ServletRequest)spiAgentHttpServletRequest, (ServletResponse)spiAgentHttpServletResponse);
        }
        catch (Exception exception2) {
            exception1 = exception2;
        }
        spiAgent.transferResponse(spiAgentHttpServletRequest, spiAgentHttpServletResponse, exception1);
        HttpSession session = spiAgentHttpServletRequest.getSession();
        session.invalidate();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            this.doService(httpServletRequest, httpServletResponse);
        }
        catch (IOException ioException) {
            _log.error(ioException, ioException);
            throw ioException;
        }
        catch (RuntimeException runtimeException) {
            _log.error(runtimeException, runtimeException);
            throw runtimeException;
        }
    }
}

