/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.remote;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.process.TerminationProcessException;
import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.mpi.MPI;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgentFactoryUtil;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RemoteSPIProxy
implements SPI {
    public static final int SIGINT = 130;
    private static final Log _log = LogFactoryUtil.getLog(RemoteSPIProxy.class);
    private final Future<SPI> _cancelHandlerFuture;
    private final MPI _mpi;
    private final RegistrationReference _registrationReference;
    private final SPI _spi;
    private final SPIAgent _spiAgent;
    private final SPIConfiguration _spiConfiguration;
    private final String _spiProviderName;

    public RemoteSPIProxy(SPI spi, SPIConfiguration spiConfiguration, String spiProviderName, Future<SPI> cancelHandlerFuture, RegistrationReference registrationReference) {
        this._spi = spi;
        this._spiConfiguration = spiConfiguration;
        this._spiProviderName = spiProviderName;
        this._cancelHandlerFuture = cancelHandlerFuture;
        this._registrationReference = registrationReference;
        this._mpi = MPIHelperUtil.getMPI();
        this._spiAgent = SPIAgentFactoryUtil.createSPIAgent(spiConfiguration, registrationReference);
    }

    @Override
    public void addServlet(String contextPath, String docBasePath, String mappingPattern, String servletClassName) throws RemoteException {
        this._spi.addServlet(contextPath, docBasePath, mappingPattern, servletClassName);
    }

    @Override
    public void addWebapp(String contextPath, String docBasePath) throws RemoteException {
        this._spi.addWebapp(contextPath, docBasePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            this._spi.destroy();
            this._cancelHandlerFuture.get(this._spiConfiguration.getShutdownTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            TerminationProcessException terminationProcessException;
            Throwable throwable;
            boolean forceDestroy = true;
            if (exception instanceof ExecutionException && (throwable = exception.getCause()) instanceof TerminationProcessException && (terminationProcessException = (TerminationProcessException)throwable).getExitCode() == 130) {
                forceDestroy = false;
            }
            if (forceDestroy) {
                this._cancelHandlerFuture.cancel(true);
                if (_log.isWarnEnabled()) {
                    _log.warn("Forcibly destroyed SPI " + this._spiConfiguration, exception);
                }
            }
        }
        finally {
            MPIHelperUtil.unregisterSPI(this);
        }
        this._spiAgent.destroy();
    }

    @Override
    public MPI getMPI() {
        return this._mpi;
    }

    @Override
    public RegistrationReference getRegistrationReference() {
        return this._registrationReference;
    }

    @Override
    public SPIAgent getSPIAgent() {
        return this._spiAgent;
    }

    @Override
    public SPIConfiguration getSPIConfiguration() {
        return this._spiConfiguration;
    }

    @Override
    public String getSPIProviderName() {
        return this._spiProviderName;
    }

    @Override
    public void init() throws RemoteException {
        this._spi.init();
        try {
            this._spiAgent.init(this);
        }
        catch (PortalResiliencyException portalResiliencyException) {
            throw new RemoteException("Unable to initialize SPI agent", portalResiliencyException);
        }
    }

    @Override
    public boolean isAlive() throws RemoteException {
        try {
            return this._spi.isAlive();
        }
        catch (RemoteException remoteException) {
            try {
                this._cancelHandlerFuture.get();
            }
            catch (Exception exception) {
                throw new RemoteException("SPI " + this.toString() + " died unexpectedly", exception);
            }
            return false;
        }
    }

    @Override
    public void start() throws RemoteException {
        this._spi.start();
    }

    @Override
    public void stop() throws RemoteException {
        this._spi.stop();
    }

    public String toString() {
        return this._spiProviderName.concat("#").concat(this._spiConfiguration.toString());
    }
}

