/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class GuestOrUserUtil {
    public static User getGuestOrUser() throws PortalException {
        return GuestOrUserUtil.getGuestOrUser(GuestOrUserUtil.getUser(GuestOrUserUtil.getUserId()));
    }

    public static User getGuestOrUser(User user) throws PortalException {
        try {
            return GuestOrUserUtil.getUser(user.getUserId());
        }
        catch (PrincipalException principalException) {
            try {
                return UserLocalServiceUtil.getDefaultUser(CompanyThreadLocal.getCompanyId());
            }
            catch (Exception exception) {
                throw principalException;
            }
        }
    }

    public static long getGuestOrUserId() throws PrincipalException {
        try {
            return GuestOrUserUtil.getUserId();
        }
        catch (PrincipalException principalException) {
            try {
                return UserLocalServiceUtil.getDefaultUserId(CompanyThreadLocal.getCompanyId());
            }
            catch (Exception exception) {
                throw principalException;
            }
        }
    }

    public static PermissionChecker getPermissionChecker() throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            throw new PrincipalException("PermissionChecker not initialized");
        }
        return permissionChecker;
    }

    public static User getUser(long userId) throws PortalException {
        return UserLocalServiceUtil.getUserById(userId);
    }

    public static long getUserId() throws PrincipalException {
        String name = PrincipalThreadLocal.getName();
        if (Validator.isNull(name)) {
            throw new PrincipalException("Principal is null");
        }
        for (String anonymousName : BaseServiceImpl.ANONYMOUS_NAMES) {
            if (!StringUtil.equalsIgnoreCase(name, anonymousName)) continue;
            throw new PrincipalException("Principal cannot be " + anonymousName);
        }
        return GetterUtil.getLong(name);
    }
}

