/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auto.login;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseAutoLogin
implements AutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(BaseAutoLogin.class);

    @Override
    @Deprecated
    public String[] handleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws AutoLoginException {
        return this.doHandleException(httpServletRequest, httpServletResponse, exception);
    }

    @Override
    public String[] login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws AutoLoginException {
        try {
            return this.doLogin(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            return this.doHandleException(httpServletRequest, httpServletResponse, exception);
        }
    }

    protected void addRedirect(HttpServletRequest httpServletRequest) {
        String redirect = ParamUtil.getString(httpServletRequest, "redirect");
        if (Validator.isNotNull(redirect)) {
            httpServletRequest.setAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE", (Object)PortalUtil.escapeRedirect(redirect));
        }
    }

    protected String[] doHandleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws AutoLoginException {
        if (httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT") == null) {
            throw new AutoLoginException(exception);
        }
        _log.error(exception, exception);
        return null;
    }

    protected abstract String[] doLogin(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

