/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.service.RetryAcceptor;
import com.liferay.portal.kernel.util.Validator;
import java.sql.SQLException;
import java.util.Map;

public class SQLStateAcceptor
implements RetryAcceptor {
    public static final String SQLSTATE = "SQLSTATE";
    public static final String SQLSTATE_INTEGRITY_CONSTRAINT_VIOLATION = "23";

    @Override
    public boolean acceptException(Throwable throwable, Map<String, String> propertyMap) {
        String sqlState = propertyMap.get(SQLSTATE);
        while (true) {
            if (throwable instanceof SQLException && this._scanForSQLState((SQLException)throwable, sqlState)) {
                return true;
            }
            Throwable causeThrowable = throwable.getCause();
            if (causeThrowable == null || causeThrowable == throwable) break;
            throwable = causeThrowable;
        }
        return false;
    }

    @Override
    public boolean acceptResult(Object returnValue, Map<String, String> propertyMap) {
        return false;
    }

    private boolean _scanForSQLState(SQLException sqlException1, String expectedSQLState) {
        while (true) {
            String sqlState;
            if (Validator.isNotNull(sqlState = sqlException1.getSQLState()) && sqlState.startsWith(expectedSQLState)) {
                return true;
            }
            SQLException sqlException2 = sqlException1.getNextException();
            if (sqlException2 == null || sqlException2.equals(sqlException1)) break;
            sqlException1 = sqlException2;
        }
        return false;
    }
}

