/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

public class SanitizedServletResponse
extends HttpServletResponseWrapper {
    private static final String _DISABLE_XSS_AUDITOR = SanitizedServletResponse.class.getName() + "DISABLE_XSS_AUDITOR";
    private static final boolean _X_CONTENT_TYPE_OPTIONS = GetterUtil.getBoolean(SystemProperties.get("http.header.secure.x.content.type.options"), true);
    private static final String[] _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES = StringUtil.split(SystemProperties.get("http.header.secure.x.content.type.options.urls.excludes"));
    private static final boolean _X_FRAME_OPTIONS;
    private static final String _X_XSS_PROTECTION;
    private static final KeyValuePair[] _xFrameOptionKVPs;

    public static void disableXSSAuditor(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("X-XSS-Protection", "0");
    }

    public static void disableXSSAuditor(PortletResponse portletResponse) {
        SanitizedServletResponse.disableXSSAuditor(PortalUtil.getHttpServletResponse(portletResponse));
    }

    public static void disableXSSAuditorOnNextRequest(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession();
        session.setAttribute(_DISABLE_XSS_AUDITOR, (Object)Boolean.TRUE);
    }

    public static void disableXSSAuditorOnNextRequest(PortletRequest portletRequest) {
        SanitizedServletResponse.disableXSSAuditorOnNextRequest(PortalUtil.getHttpServletRequest(portletRequest));
    }

    public static HttpServletResponse getSanitizedServletResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SanitizedServletResponse.setXContentOptions(httpServletRequest, httpServletResponse);
        SanitizedServletResponse.setXFrameOptions(httpServletRequest, httpServletResponse);
        SanitizedServletResponse.setXXSSProtection(httpServletRequest, httpServletResponse);
        return httpServletResponse;
    }

    public void addHeader(String name, String value) {
        super.addHeader(HttpUtil.sanitizeHeader(name), HttpUtil.sanitizeHeader(value));
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(HttpUtil.sanitizeHeader(location));
    }

    public void setCharacterEncoding(String charset) {
        super.setCharacterEncoding(HttpUtil.sanitizeHeader(charset));
    }

    public void setContentType(String type) {
        super.setContentType(HttpUtil.sanitizeHeader(type));
    }

    public void setHeader(String name, String value) {
        super.setHeader(HttpUtil.sanitizeHeader(name), HttpUtil.sanitizeHeader(value));
    }

    protected static void setXContentOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!_X_CONTENT_TYPE_OPTIONS) {
            return;
        }
        if (_X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES.length > 0) {
            String requestURI = httpServletRequest.getRequestURI();
            for (String url : _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES) {
                if (!requestURI.startsWith(url)) continue;
                return;
            }
        }
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
    }

    protected static void setXFrameOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!_X_FRAME_OPTIONS) {
            return;
        }
        String requestURI = httpServletRequest.getRequestURI();
        for (KeyValuePair xFrameOptionKVP : _xFrameOptionKVPs) {
            String url = xFrameOptionKVP.getKey();
            if (!requestURI.startsWith(url)) continue;
            String value = xFrameOptionKVP.getValue();
            if (value != null) {
                httpServletResponse.setHeader("X-Frame-Options", xFrameOptionKVP.getValue());
            }
            return;
        }
        httpServletResponse.setHeader("X-Frame-Options", "DENY");
    }

    protected static void setXXSSProtection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null && session.getAttribute(_DISABLE_XSS_AUDITOR) != null) {
            session.removeAttribute(_DISABLE_XSS_AUDITOR);
            httpServletResponse.setHeader("X-XSS-Protection", "0");
            return;
        }
        if (_X_XSS_PROTECTION == null) {
            return;
        }
        httpServletResponse.setHeader("X-XSS-Protection", _X_XSS_PROTECTION);
    }

    private SanitizedServletResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    static {
        String httpHeaderSecureXFrameOptionsKey = "http.header.secure.x.frame.options";
        SortedProperties properties = new SortedProperties(new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                return GetterUtil.getIntegerStrict(key1) - GetterUtil.getIntegerStrict(key2);
            }
        }, PropertiesUtil.getProperties(SystemProperties.getProperties(), httpHeaderSecureXFrameOptionsKey.concat("."), true));
        ArrayList<KeyValuePair> xFrameOptionKVPs = new ArrayList<KeyValuePair>(properties.size());
        for (Map.Entry<Object, Object> entry : ((Properties)properties).entrySet()) {
            String url;
            String propertyValue = (String)entry.getValue();
            String[] propertyValueParts = StringUtil.split(propertyValue, '|');
            if (propertyValueParts.length > 2 || Validator.isNull(url = StringUtil.trim(propertyValueParts[0]))) continue;
            if (propertyValueParts.length == 1) {
                xFrameOptionKVPs.add(new KeyValuePair(url, null));
                continue;
            }
            String value = StringUtil.trim(propertyValueParts[1]);
            if (Validator.isNull(value)) {
                value = null;
            }
            xFrameOptionKVPs.add(new KeyValuePair(url, value));
        }
        _xFrameOptionKVPs = xFrameOptionKVPs.toArray(new KeyValuePair[0]);
        _X_FRAME_OPTIONS = _xFrameOptionKVPs.length == 0 ? false : GetterUtil.getBoolean(SystemProperties.get(httpHeaderSecureXFrameOptionsKey), true);
        String xXssProtection = SystemProperties.get("http.header.secure.x.xss.protection");
        _X_XSS_PROTECTION = Validator.isNull(xXssProtection) ? null : xXssProtection;
    }
}

