/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.aui;

import com.liferay.portal.kernel.util.Mergeable;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class ScriptData
implements Mergeable<ScriptData>,
Serializable {
    private static final Set<String> _reservedWords = new HashSet<String>(Arrays.asList("arguments", "await", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "eval", "export", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "null", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "yield"));
    private static final Pattern _whitespacePattern = Pattern.compile("\\s+");
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<String, PortletData> _portletDataMap = new ConcurrentHashMap<String, PortletData>();

    public void append(String portletId, String content, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(content, modules, modulesType);
    }

    public void append(String portletId, StringBundler contentSB, String modules, ModulesType modulesType) {
        PortletData portletData = this._getPortletData(portletId);
        portletData.append(contentSB, modules, modulesType);
    }

    public void mark() {
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData.mark();
        }
    }

    @Override
    public ScriptData merge(ScriptData scriptData) {
        if (scriptData != null && scriptData != this) {
            this._portletDataMap.putAll(scriptData._portletDataMap);
        }
        return this;
    }

    public void reset() {
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData.reset();
        }
    }

    @Override
    public ScriptData split() {
        return new ScriptData();
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<script type=\"text/javascript\">\n// <![CDATA[\n");
        for (PortletData portletData : this._portletDataMap.values()) {
            portletData._rawSB.writeTo(writer);
        }
        Collection<PortletData> portletDataCollection = this._portletDataMap.values();
        this._writeEs6ModulesTo(writer, portletDataCollection);
        this._writeAuiModulesTo(writer, portletDataCollection);
        writer.write("\n// ]]>\n</script>");
    }

    public void writeTo(Writer writer, String portletId) throws IOException {
        PortletData portletData = (PortletData)this._portletDataMap.remove(portletId);
        if (portletData == null) {
            return;
        }
        writer.write("<script type=\"text/javascript\">\n// <![CDATA[\n");
        portletData._rawSB.writeTo(writer);
        Set<PortletData> portletDataCollection = Collections.singleton(portletData);
        if (!portletData._es6ModulesSet.isEmpty()) {
            this._writeEs6ModulesTo(writer, portletDataCollection);
        }
        if (!portletData._auiModulesSet.isEmpty()) {
            this._writeAuiModulesTo(writer, portletDataCollection);
        }
        writer.write("\n// ]]>\n</script>");
    }

    private String _generateModuleName(String name) {
        String[] nameAlias = this._splitNameAlias(name);
        return nameAlias[0];
    }

    private String _generateVariable(String name, Set<String> names, boolean useAlias) {
        String[] nameAlias = this._splitNameAlias(name);
        if (useAlias && !Validator.isBlank(nameAlias[1])) {
            return nameAlias[1];
        }
        name = nameAlias[0];
        StringBuilder sb = new StringBuilder(name.length());
        char c = name.charAt(0);
        boolean modified = true;
        if ('a' <= c && c <= 'z' || c == '_') {
            sb.append(c);
            modified = false;
        } else if ('A' <= c && c <= 'Z') {
            sb.append((char)(c + 32));
        } else {
            sb.append('_');
        }
        boolean startNewWord = false;
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if ('a' <= c && c <= 'z') {
                if (startNewWord) {
                    sb.append((char)(c - 32));
                    startNewWord = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_') {
                sb.append(c);
                startNewWord = false;
                continue;
            }
            modified = true;
            startNewWord = true;
        }
        if (_reservedWords.contains(name)) {
            name = "_" + name;
        }
        String safeName = name;
        if (modified) {
            name = safeName = sb.toString();
        }
        int i = 1;
        while (!names.add(name)) {
            name = safeName.concat(String.valueOf(i++));
        }
        return name;
    }

    private PortletData _getPortletData(String portletId) {
        PortletData oldPortletData;
        PortletData portletData;
        if (Validator.isNull(portletId)) {
            portletId = "";
        }
        if ((portletData = (PortletData)this._portletDataMap.get(portletId)) == null && (oldPortletData = this._portletDataMap.putIfAbsent(portletId, portletData = new PortletData())) != null) {
            portletData = oldPortletData;
        }
        return portletData;
    }

    private String[] _splitNameAlias(String name) {
        String[] parts = _whitespacePattern.split(name, 4);
        if (parts.length == 3 && StringUtil.equalsIgnoreCase(parts[1], "as")) {
            return new String[]{parts[0], parts[2]};
        }
        return new String[]{name, ""};
    }

    private void _writeAuiModulesTo(Writer writer, Collection<PortletData> portletDataCollection) throws IOException {
        StringBundler auiModulesSB = new StringBundler(portletDataCollection.size());
        HashSet auiModulesSet = new HashSet();
        for (PortletData portletData : portletDataCollection) {
            if (portletData._auiModulesSet.isEmpty()) continue;
            auiModulesSB.append(portletData._auiCallbackSB);
            auiModulesSet.addAll(portletData._auiModulesSet);
        }
        if (!auiModulesSet.isEmpty()) {
            writer.write("AUI().use(");
            for (String use : auiModulesSet) {
                writer.write("'");
                writer.write(use);
                writer.write("'");
                writer.write(", ");
            }
            writer.write("function(A) {");
            auiModulesSB.writeTo(writer);
            writer.write("});");
        }
    }

    private void _writeEs6ModulesTo(Writer writer, Collection<PortletData> portletDataCollection) throws IOException {
        StringBundler es6CallbacksSB = new StringBundler(portletDataCollection.size());
        ArrayList<String> es6Modules = new ArrayList<String>();
        ArrayList<String> es6Variables = new ArrayList<String>();
        HashSet<String> variableNames = new HashSet<String>();
        for (PortletData portletData : portletDataCollection) {
            if (portletData._es6ModulesSet.isEmpty()) continue;
            es6CallbacksSB.append("(function(){\n");
            for (String es6Module : portletData._es6ModulesSet) {
                es6Modules.add(this._generateModuleName(es6Module));
                String rawVariable = this._generateVariable(es6Module, variableNames, false);
                es6Variables.add(rawVariable);
                es6CallbacksSB.append("var ");
                String aliasedVariable = this._generateVariable(es6Module, variableNames, true);
                es6CallbacksSB.append(aliasedVariable);
                es6CallbacksSB.append(" = ");
                es6CallbacksSB.append(rawVariable);
                es6CallbacksSB.append(";\n");
            }
            es6CallbacksSB.append(portletData._es6CallbackSB);
            es6CallbacksSB.append("})();\n");
        }
        if (!es6Modules.isEmpty()) {
            writer.write("Liferay.Loader.require(");
            for (String es6Module : es6Modules) {
                writer.write("'");
                writer.write(es6Module);
                writer.write("'");
                writer.write(", ");
            }
            writer.write("function(");
            String delimiter = "";
            for (String es6Variable : es6Variables) {
                writer.write(delimiter);
                writer.write(es6Variable);
                delimiter = ", ";
            }
            writer.write(") {\n");
            es6CallbacksSB.writeTo(writer);
            writer.write("});");
        }
    }

    private static class PortletData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final StringBundler _auiCallbackSB = new StringBundler();
        private int _auiCallbackSBIndex = -1;
        private final Set<String> _auiModulesSet = new HashSet<String>();
        private final StringBundler _es6CallbackSB = new StringBundler();
        private int _es6CallbackSBIndex = -1;
        private final Set<String> _es6ModulesSet = new HashSet<String>();
        private final StringBundler _rawSB = new StringBundler();
        private int _rawSBIndex = -1;

        private PortletData() {
        }

        public void append(String content, String modules, ModulesType modulesType) {
            if (Validator.isNull(modules)) {
                this._rawSB.append(content);
            } else {
                String[] modulesArray = StringUtil.split(modules);
                if (modulesType == ModulesType.AUI) {
                    this._auiCallbackSB.append("(function() {");
                    this._auiCallbackSB.append(content);
                    this._auiCallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._auiModulesSet.add(StringUtil.trim(module));
                    }
                } else {
                    this._es6CallbackSB.append("(function() {\n");
                    this._es6CallbackSB.append("try {\n");
                    this._es6CallbackSB.append(content);
                    this._es6CallbackSB.append("\n}\n");
                    this._es6CallbackSB.append("catch (err) {\n");
                    this._es6CallbackSB.append("console.error(err);\n");
                    this._es6CallbackSB.append("}\n");
                    this._es6CallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._es6ModulesSet.add(StringUtil.trim(module));
                    }
                }
            }
        }

        public void append(StringBundler contentSB, String modules, ModulesType modulesType) {
            if (Validator.isNull(modules)) {
                this._rawSB.append(contentSB);
            } else {
                String[] modulesArray = StringUtil.split(modules);
                if (modulesType == ModulesType.AUI) {
                    this._auiCallbackSB.append("(function() {");
                    this._auiCallbackSB.append(contentSB);
                    this._auiCallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._auiModulesSet.add(StringUtil.trim(module));
                    }
                } else {
                    this._es6CallbackSB.append("(function() {");
                    this._es6CallbackSB.append(contentSB);
                    this._es6CallbackSB.append("})();");
                    for (String module : modulesArray) {
                        this._es6ModulesSet.add(StringUtil.trim(module));
                    }
                }
            }
        }

        public void mark() {
            this._auiCallbackSBIndex = this._auiCallbackSB.index();
            this._es6CallbackSBIndex = this._es6CallbackSB.index();
            this._rawSBIndex = this._rawSB.index();
        }

        public void reset() {
            if (this._auiCallbackSBIndex >= 0) {
                this._auiCallbackSB.setIndex(this._auiCallbackSBIndex);
            }
            if (this._es6CallbackSBIndex >= 0) {
                this._es6CallbackSB.setIndex(this._es6CallbackSBIndex);
            }
            if (this._rawSBIndex >= 0) {
                this._rawSB.setIndex(this._rawSBIndex);
            }
        }
    }

    public static enum ModulesType {
        AUI,
        ES6;

    }
}

