/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.resource.ResourceRetriever;
import com.liferay.portal.kernel.resource.manager.ResourceManager;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.SettingsLocatorHelperUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;

public class LocationVariableResolver {
    private static final String _LOCATION_VARIABLE_END = "}";
    private static final String _LOCATION_VARIABLE_PROTOCOL_SEPARATOR = ":";
    private static final String _LOCATION_VARIABLE_START = "${";
    private final ResourceManager _resourceManager;
    private final SettingsLocatorHelper _settingsLocatorHelper;

    @Deprecated
    public LocationVariableResolver(ResourceManager resourceManager, SettingsFactory settingsFactory) {
        this._resourceManager = resourceManager;
        this._settingsLocatorHelper = SettingsLocatorHelperUtil.getSettingsLocatorHelper();
    }

    public LocationVariableResolver(ResourceManager resourceManager, SettingsLocatorHelper settingsLocatorHelper) {
        this._resourceManager = resourceManager;
        this._settingsLocatorHelper = settingsLocatorHelper;
    }

    public boolean isLocationVariable(String value) {
        if (value == null) {
            return false;
        }
        return value.startsWith(_LOCATION_VARIABLE_START) && value.endsWith(_LOCATION_VARIABLE_END) && value.contains(_LOCATION_VARIABLE_PROTOCOL_SEPARATOR);
    }

    public String resolve(String value) {
        String protocol = this._getProtocol(value);
        String location = this._getLocation(value);
        if (protocol.equals("resource")) {
            return this._resolveResource(location);
        }
        if (protocol.equals("file")) {
            return this._resolveFile(location);
        }
        if (protocol.equals("server-property")) {
            return this._resolveServerProperty(location);
        }
        throw new UnsupportedOperationException("Unsupported protocol " + protocol);
    }

    private String _getLocation(String value) {
        int i = value.indexOf(_LOCATION_VARIABLE_PROTOCOL_SEPARATOR);
        return value.substring(i + 1, value.length() - 1);
    }

    private String _getProtocol(String value) {
        int i = value.indexOf(_LOCATION_VARIABLE_PROTOCOL_SEPARATOR);
        return value.substring(2, i);
    }

    private String _resolveFile(String location) {
        if (!location.startsWith("///")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Invalid file location ", location, " because only local ", "file URIs starting with file:/// are supported"}));
        }
        try {
            return StringUtil.read(new FileInputStream(location.substring(2)));
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to read file " + location, ioException);
        }
    }

    private String _resolveResource(String location) {
        ResourceRetriever resourceRetriever = this._resourceManager.getResourceRetriever(location);
        try {
            return StringUtil.read(resourceRetriever.getInputStream());
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to read resource " + location, ioException);
        }
    }

    private String _resolveServerProperty(String location) {
        if (!location.startsWith("//")) {
            throw new IllegalArgumentException("Invalid server property location " + location);
        }
        int i = (location = location.substring(2)).indexOf("/");
        if (i == -1) {
            throw new IllegalArgumentException("Invalid server property location " + location);
        }
        String serviceName = location.substring(0, i);
        Settings settings = this._settingsLocatorHelper.getServerSettings(serviceName);
        String property = location.substring(i + 1);
        return settings.getValue(property, null);
    }
}

