/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicReference;

public class TransactionLifecycleManager {
    private static final AtomicReference<TransactionLifecycleListener[]> _transactionLifecycleListenersReference = new AtomicReference<TransactionLifecycleListener[]>(new TransactionLifecycleListener[0]);

    public static void fireTransactionCommittedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        for (TransactionLifecycleListener transactionLifecycleListener : _transactionLifecycleListenersReference.get()) {
            try {
                transactionLifecycleListener.committed(transactionAttribute, transactionStatus);
            }
            catch (Throwable t) {
                transactionStatus.suppressLifecycleListenerThrowable(t);
            }
        }
    }

    public static void fireTransactionCreatedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        for (TransactionLifecycleListener transactionLifecycleListener : _transactionLifecycleListenersReference.get()) {
            try {
                transactionLifecycleListener.created(transactionAttribute, transactionStatus);
            }
            catch (Throwable t) {
                transactionStatus.suppressLifecycleListenerThrowable(t);
            }
        }
    }

    public static void fireTransactionRollbackedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
        for (TransactionLifecycleListener transactionLifecycleListener : _transactionLifecycleListenersReference.get()) {
            try {
                transactionLifecycleListener.rollbacked(transactionAttribute, transactionStatus, throwable);
            }
            catch (Throwable t) {
                transactionStatus.suppressLifecycleListenerThrowable(t);
            }
        }
    }

    public static TransactionLifecycleListener[] getRegisteredTransactionLifecycleListeners() {
        TransactionLifecycleListener[] transactionLifecycleListeners = _transactionLifecycleListenersReference.get();
        return (TransactionLifecycleListener[])transactionLifecycleListeners.clone();
    }

    public static boolean register(TransactionLifecycleListener transactionLifecycleListener) {
        TransactionLifecycleListener[] newTransactionLifecycleListeners;
        Object[] transactionLifecycleListeners;
        do {
            if (!ArrayUtil.contains(transactionLifecycleListeners = _transactionLifecycleListenersReference.get(), transactionLifecycleListener)) continue;
            return false;
        } while (!_transactionLifecycleListenersReference.compareAndSet((TransactionLifecycleListener[])transactionLifecycleListeners, newTransactionLifecycleListeners = ArrayUtil.append(transactionLifecycleListeners, transactionLifecycleListener)));
        return true;
    }

    public static boolean unregister(TransactionLifecycleListener transactionLifecycleListener) {
        TransactionLifecycleListener[] newTransactionLifecycleListeners;
        TransactionLifecycleListener[] transactionLifecycleListeners;
        do {
            if ((transactionLifecycleListeners = _transactionLifecycleListenersReference.get()) != (newTransactionLifecycleListeners = ArrayUtil.remove(transactionLifecycleListeners, transactionLifecycleListener))) continue;
            return false;
        } while (!_transactionLifecycleListenersReference.compareAndSet(transactionLifecycleListeners, newTransactionLifecycleListeners));
        return true;
    }
}

