/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.trash;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.kernel.model.TrashEntry;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseTrashHandler
implements TrashHandler {
    private static final Log _log = LogFactoryUtil.getLog(BaseTrashHandler.class);

    @Override
    public SystemEvent addDeletionSystemEvent(long userId, long groupId, long classPK, String classUuid, String referrerClassName) throws PortalException {
        JSONObject extraDataJSONObject = JSONUtil.put("inTrash", (Object)true);
        return SystemEventLocalServiceUtil.addSystemEvent(userId, groupId, this.getSystemEventClassName(), classPK, classUuid, referrerClassName, 1, extraDataJSONObject.toString());
    }

    @Override
    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
    }

    @Override
    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
    }

    @Override
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return null;
    }

    @Override
    public String getContainerModelClassName(long classPK) {
        return "";
    }

    @Override
    public String getContainerModelName() {
        return "";
    }

    @Override
    public List<ContainerModel> getContainerModels(long classPK, long containerModelId, int start, int end) throws PortalException {
        return Collections.emptyList();
    }

    @Override
    public int getContainerModelsCount(long classPK, long containerModelId) throws PortalException {
        return 0;
    }

    @Override
    public String getDeleteMessage() {
        return "deleted-in-x";
    }

    @Override
    public long getDestinationContainerModelId(long classPK, long destinationContainerModelId) {
        return destinationContainerModelId;
    }

    @Override
    public Filter getExcludeFilter(SearchContext searchContext) {
        return null;
    }

    @Override
    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        return null;
    }

    @Override
    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        if (trashedModel == null || !(trashedModel instanceof ContainerModel)) {
            return null;
        }
        ContainerModel containerModel = (ContainerModel)((Object)trashedModel);
        return this.getContainerModel(containerModel.getParentContainerModelId());
    }

    @Override
    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        return Collections.emptyList();
    }

    @Override
    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        return "";
    }

    @Override
    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        return "";
    }

    @Override
    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        return "";
    }

    @Override
    public String getRootContainerModelName() {
        return "";
    }

    @Override
    public String getSubcontainerModelName() {
        return "";
    }

    @Override
    public String getSystemEventClassName() {
        return this.getClassName();
    }

    @Override
    public String getTrashContainedModelName() {
        return "";
    }

    @Override
    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        return 0;
    }

    @Override
    @Deprecated
    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException {
        return Collections.emptyList();
    }

    @Override
    public String getTrashContainerModelName() {
        return "";
    }

    @Override
    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        return 0;
    }

    @Override
    @Deprecated
    public List<TrashRenderer> getTrashContainerModelTrashRenderers(long classPK, int start, int end) throws PortalException {
        return Collections.emptyList();
    }

    @Override
    public TrashedModel getTrashedModel(long classPK) {
        return null;
    }

    @Override
    public int getTrashModelsCount(long classPK) throws PortalException {
        return 0;
    }

    @Override
    @Deprecated
    public List<TrashRenderer> getTrashModelTrashRenderers(long classPK, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return Collections.emptyList();
    }

    @Override
    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        AssetRenderer<?> assetRenderer;
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null && (assetRenderer = assetRendererFactory.getAssetRenderer(classPK)) instanceof TrashRenderer) {
            return (TrashRenderer)((Object)assetRenderer);
        }
        return null;
    }

    @Override
    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return false;
        }
        String actionId = trashActionId;
        if (trashActionId.equals("OVERWRITE") || trashActionId.equals("RESTORE")) {
            actionId = "DELETE";
        } else if (trashActionId.equals("RENAME")) {
            actionId = "UPDATE";
        }
        return this.hasPermission(permissionChecker, classPK, actionId);
    }

    @Override
    public boolean isContainerModel() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isDeletable() {
        return true;
    }

    @Override
    public boolean isDeletable(long classPK) throws PortalException {
        return this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), 0L, classPK, "DELETE");
    }

    @Override
    @Deprecated
    public boolean isMovable() {
        return false;
    }

    @Override
    public boolean isMovable(long classPK) throws PortalException {
        return false;
    }

    @Override
    public boolean isRestorable(long classPK) throws PortalException {
        return true;
    }

    @Override
    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
    }

    @Override
    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        if (this.isRestorable(classPK)) {
            this.restoreTrashEntry(userId, classPK);
        }
        Class<?> clazz = this.getClass();
        _log.error("moveTrashEntry() is not implemented in " + clazz.getName());
        throw new SystemException();
    }

    @Override
    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException {
    }

    @Override
    public void updateTitle(long classPK, String title) throws PortalException {
    }

    protected AssetRendererFactory<?> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
    }

    protected abstract boolean hasPermission(PermissionChecker var1, long var2, String var4) throws PortalException;
}

