/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseUpgradeLocalizedColumn
extends UpgradeProcess {
    private static final Set<String> _alteredTableNameColumnNames = new HashSet<String>();

    protected void upgradeLocalizedColumn(ResourceBundleLoader resourceBundleLoader, Class<?> tableClass, String columnName, String originalContent, String localizationMapKey, String localizationXMLKey, long[] companyIds) throws SQLException {
        Class<?> clazz = this.getClass();
        resourceBundleLoader = new AggregateResourceBundleLoader(ResourceBundleUtil.getResourceBundleLoader("content.Language", clazz.getClassLoader()), resourceBundleLoader);
        try {
            String tableName = this.getTableName(tableClass);
            if (!this.hasColumnType(tableName, columnName, "TEXT null") && !_alteredTableNameColumnNames.contains(tableName + "#" + columnName)) {
                this.alter(tableClass, new UpgradeProcess.AlterColumnType(this, columnName, "TEXT null"));
                _alteredTableNameColumnNames.add(tableName + "#" + columnName);
            }
            for (long companyId : companyIds) {
                this._upgrade(resourceBundleLoader, tableClass, columnName, originalContent, localizationMapKey, localizationXMLKey, companyId);
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Deprecated
    protected void upgradeLocalizedColumn(ResourceBundleLoader resourceBundleLoader, String tableName, String columnName, String originalContent, String localizationMapKey, String localizationXMLKey, long[] companyIds) throws SQLException {
        Class<?> clazz = this.getClass();
        resourceBundleLoader = new AggregateResourceBundleLoader(ResourceBundleUtil.getResourceBundleLoader("content.Language", clazz.getClassLoader()), resourceBundleLoader);
        for (long companyId : companyIds) {
            this._upgrade(resourceBundleLoader, tableName, columnName, originalContent, localizationMapKey, localizationXMLKey, companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getLocalizationXML(String localizationMapKey, String localizationXMLKey, long companyId, ResourceBundleLoader resourceBundleLoader) throws SQLException {
        Long originalCompanyId = CompanyThreadLocal.getCompanyId();
        CompanyThreadLocal.setCompanyId(companyId);
        try {
            Map<Locale, String> localizationMap = ResourceBundleUtil.getLocalizationMap(resourceBundleLoader, localizationMapKey);
            String string = LocalizationUtil.updateLocalization(localizationMap, "", localizationXMLKey, UpgradeProcessUtil.getDefaultLanguageId(companyId));
            return string;
        }
        finally {
            CompanyThreadLocal.setCompanyId(originalCompanyId);
        }
    }

    private void _upgrade(ResourceBundleLoader resourceBundleLoader, Class<?> tableClass, String columnName, String originalContent, String localizationMapKey, String localizationXMLKey, long companyId) throws Exception {
        this._upgrade(resourceBundleLoader, this.getTableName(tableClass), columnName, originalContent, localizationMapKey, localizationXMLKey, companyId);
    }

    private void _upgrade(ResourceBundleLoader resourceBundleLoader, String tableName, String columnName, String originalContent, String localizationMapKey, String localizationXMLKey, long companyId) throws SQLException {
        String localizationXML = this._getLocalizationXML(localizationMapKey, localizationXMLKey, companyId, resourceBundleLoader);
        String sql = StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = ? where ", columnName, " like ? and companyId = ?"});
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, localizationXML);
            ps.setString(2, originalContent);
            ps.setLong(3, companyId);
            ps.executeUpdate();
        }
        catch (SQLException sqlException) {
            throw new SystemException(sqlException);
        }
    }
}

