/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public abstract class RenameUpgradePortalPreferences
extends UpgradeProcess {
    @Override
    protected void doUpgrade() throws Exception {
        Map<String, String> preferenceNamesMap = this.getPreferenceNamesMap();
        for (Map.Entry<String, String> entry : preferenceNamesMap.entrySet()) {
            this.updatePreferences("PortalPreferences", "portalPreferencesId", entry.getKey(), entry.getValue());
        }
    }

    protected abstract Map<String, String> getPreferenceNamesMap();

    protected void updatePreferences(String tableName, String primaryKeyColumnName, String oldValue, String newValue) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            StringBundler sb = new StringBundler(9);
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set preferences = replace(preferences, '");
            sb.append(oldValue);
            sb.append("', '");
            sb.append(newValue);
            sb.append("') where preferences like '%");
            sb.append(oldValue);
            sb.append("%'");
            try {
                this.runSQL(sb.toString());
            }
            catch (Exception exception) {
                sb = new StringBundler(7);
                sb.append("select ");
                sb.append(primaryKeyColumnName);
                sb.append(", preferences from ");
                sb.append(tableName);
                sb.append(" where preferences like '%");
                sb.append(oldValue);
                sb.append("%'");
                try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                     ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        long primaryKey = rs.getLong(primaryKeyColumnName);
                        String preferences = rs.getString("preferences");
                        this.updatePreferences(tableName, primaryKeyColumnName, oldValue, newValue, primaryKey, preferences);
                    }
                }
            }
        }
    }

    protected void updatePreferences(String tableName, String primaryKeyColumnName, String oldValue, String newValue, long primaryKey, String preferences) throws Exception {
        preferences = StringUtil.replace(preferences, oldValue, newValue);
        StringBundler sb = new StringBundler(5);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set preferences = ? where ");
        sb.append(primaryKeyColumnName);
        sb.append(" = ?");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setString(1, preferences);
            ps.setLong(2, primaryKey);
            ps.executeUpdate();
        }
    }
}

