/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.v6_2_0;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseUpgradeAttachments
extends UpgradeProcess {
    private static final String _LIFERAY_REPOSITORY_CLASS_NAME = "com.liferay.portal.repository.liferayrepository.LiferayRepository";
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradeAttachments.class);
    private final Map<String, Map<String, Long>> _bitwiseValues = new HashMap<String, Map<String, Long>>();
    private final Map<String, Long> _roleIds = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addDLFileEntry(long groupId, long companyId, long userId, String className, long classPK, String userName, Timestamp createDate, long repositoryId, long folderId, String name, String extension, String mimeType, String title, long size) throws Exception {
        PreparedStatement ps = null;
        try {
            long fileEntryId = this.increment();
            StringBundler sb = new StringBundler(9);
            sb.append("insert into DLFileEntry (uuid_, fileEntryId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, classNameId, classPK, repositoryId, ");
            sb.append("folderId, name, extension, mimeType, title, ");
            sb.append("description, extraSettings, fileEntryTypeId, version, ");
            sb.append("size_, readCount, smallImageId, largeImageId, ");
            sb.append("custom1ImageId, custom2ImageId) values (?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?)");
            String sql = sb.toString();
            ps = this.connection.prepareStatement(sql);
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, fileEntryId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, createDate);
            ps.setLong(9, PortalUtil.getClassNameId(className));
            ps.setLong(10, classPK);
            ps.setLong(11, repositoryId);
            ps.setLong(12, folderId);
            ps.setString(13, name);
            ps.setString(14, extension);
            ps.setString(15, mimeType);
            ps.setString(16, title);
            ps.setString(17, "");
            ps.setString(18, "");
            ps.setLong(19, 0L);
            ps.setString(20, "1.0");
            ps.setLong(21, size);
            ps.setInt(22, 0);
            ps.setLong(23, 0L);
            ps.setLong(24, 0L);
            ps.setLong(25, 0L);
            ps.setLong(26, 0L);
            ps.executeUpdate();
            Map<String, Long> bitwiseValues = this.getBitwiseValues("com.liferay.portlet.documentlibrary.model.DLFileEntry");
            long bitwiseValue = this.getBitwiseValue(bitwiseValues, ListUtil.fromArray("VIEW"));
            this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFileEntry", fileEntryId, this.getRoleId(companyId, "Guest"), bitwiseValue);
            this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFileEntry", fileEntryId, this.getRoleId(companyId, "Site Member"), bitwiseValue);
            long l = fileEntryId;
            DataAccess.cleanUp(ps);
            return l;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to add file entry " + name, exception);
            }
            long l = -1L;
            return l;
        }
        finally {
            DataAccess.cleanUp(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDLFileVersion(long fileVersionId, long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, long folderId, long fileEntryId, String extension, String mimeType, String title, long size) throws Exception {
        PreparedStatement ps = null;
        try {
            StringBundler sb = new StringBundler(8);
            sb.append("insert into DLFileVersion (uuid_, fileVersionId, ");
            sb.append("groupId, companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, repositoryId, folderId, fileEntryId, ");
            sb.append("extension, mimeType, title, description, changeLog, ");
            sb.append("extraSettings, fileEntryTypeId, version, size_, ");
            sb.append("status, statusByUserId, statusByUserName, statusDate) ");
            sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = this.connection.prepareStatement(sql);
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, fileVersionId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, createDate);
            ps.setLong(9, repositoryId);
            ps.setLong(10, folderId);
            ps.setLong(11, fileEntryId);
            ps.setString(12, extension);
            ps.setString(13, mimeType);
            ps.setString(14, title);
            ps.setString(15, "");
            ps.setString(16, "");
            ps.setString(17, "");
            ps.setLong(18, 0L);
            ps.setString(19, "1.0");
            ps.setLong(20, size);
            ps.setInt(21, 0);
            ps.setLong(22, userId);
            ps.setString(23, userName);
            ps.setTimestamp(24, createDate);
            ps.executeUpdate();
            DataAccess.cleanUp(ps);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to add file version 1.0 for file entry " + title, exception);
            }
        }
        finally {
            DataAccess.cleanUp(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addDLFolder(long folderId, long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, boolean mountPoint, long parentFolderId, String name, boolean hidden) throws Exception {
        PreparedStatement ps = null;
        try {
            StringBundler sb = new StringBundler(8);
            sb.append("insert into DLFolder (uuid_, folderId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, repositoryId, mountPoint, ");
            sb.append("parentFolderId, name, description, lastPostDate, ");
            sb.append("defaultFileEntryTypeId, hidden_, ");
            sb.append("overrideFileEntryTypes, status, statusByUserId, ");
            sb.append("statusByUserName, statusDate) values (?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = this.connection.prepareStatement(sql);
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, folderId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, createDate);
            ps.setLong(9, repositoryId);
            ps.setBoolean(10, mountPoint);
            ps.setLong(11, parentFolderId);
            ps.setString(12, name);
            ps.setString(13, "");
            ps.setTimestamp(14, createDate);
            ps.setLong(15, 0L);
            ps.setBoolean(16, hidden);
            ps.setBoolean(17, false);
            ps.setLong(18, 0L);
            ps.setLong(19, userId);
            ps.setString(20, userName);
            ps.setTimestamp(21, createDate);
            ps.executeUpdate();
            Map<String, Long> bitwiseValues = this.getBitwiseValues("com.liferay.portlet.documentlibrary.model.DLFolder");
            long guestBitwiseValue = this.getBitwiseValue(bitwiseValues, ListUtil.fromArray("VIEW"));
            this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFolder", folderId, this.getRoleId(companyId, "Guest"), guestBitwiseValue);
            ArrayList<String> siteMemberActionIds = new ArrayList<String>();
            siteMemberActionIds.add("ADD_DOCUMENT");
            siteMemberActionIds.add("ADD_SUBFOLDER");
            siteMemberActionIds.add("VIEW");
            long siteMemberBitwiseValue = this.getBitwiseValue(bitwiseValues, siteMemberActionIds);
            this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFolder", folderId, this.getRoleId(companyId, "Site Member"), siteMemberBitwiseValue);
            long l = folderId;
            DataAccess.cleanUp(ps);
            return l;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to add folder " + name, exception);
            }
            long l = -1L;
            return l;
        }
        finally {
            DataAccess.cleanUp(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addRepository(long groupId, long companyId, long userId, String userName, Timestamp createDate, long classNameId, String portletId) throws Exception {
        long repositoryId = this.increment();
        long folderId = this.addDLFolder(this.increment(), groupId, companyId, userId, userName, createDate, repositoryId, true, 0L, portletId, true);
        if (folderId < 0L) {
            return -1L;
        }
        PreparedStatement ps = null;
        try {
            StringBundler sb = new StringBundler(5);
            sb.append("insert into Repository (uuid_, repositoryId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, classNameId, name, description, ");
            sb.append("portletId, typeSettings, dlFolderId) values (?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = this.connection.prepareStatement(sb.toString());
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, repositoryId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, createDate);
            ps.setLong(9, classNameId);
            ps.setString(10, portletId);
            ps.setString(11, "");
            ps.setString(12, portletId);
            ps.setString(13, "");
            ps.setLong(14, folderId);
            ps.executeUpdate();
            long l = repositoryId;
            DataAccess.cleanUp(ps);
            return l;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to add repository for portlet " + portletId, exception);
            }
            long l = -1L;
            return l;
        }
        finally {
            DataAccess.cleanUp(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResourcePermission(long companyId, String className, long primKey, long roleId, long actionIds) throws Exception {
        PreparedStatement ps = null;
        try {
            long resourcePermissionId = this.increment(ResourcePermission.class.getName());
            StringBundler sb = new StringBundler(3);
            sb.append("insert into ResourcePermission (resourcePermissionId, ");
            sb.append("companyId, name, scope, primKey, roleId, ownerId, ");
            sb.append("actionIds) values (?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = this.connection.prepareStatement(sql);
            ps.setLong(1, resourcePermissionId);
            ps.setLong(2, companyId);
            ps.setString(3, className);
            ps.setInt(4, 4);
            ps.setLong(5, primKey);
            ps.setLong(6, roleId);
            ps.setLong(7, 0L);
            ps.setLong(8, actionIds);
            ps.executeUpdate();
            DataAccess.cleanUp(ps);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to add resource permission " + className, exception);
            }
        }
        finally {
            DataAccess.cleanUp(ps);
        }
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.updateAttachments();
    }

    protected String[] getAttachments(long companyId, long containerModelId, long resourcePrimKey) throws Exception {
        return DLStoreUtil.getFileNames(companyId, 0L, this.getDirName(containerModelId, resourcePrimKey));
    }

    protected long getBitwiseValue(Map<String, Long> bitwiseValues, List<String> actionIds) {
        long bitwiseValue = 0L;
        for (String actionId : actionIds) {
            Long actionIdBitwiseValue = bitwiseValues.get(actionId);
            if (actionIdBitwiseValue == null) continue;
            bitwiseValue |= actionIdBitwiseValue.longValue();
        }
        return bitwiseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Long> getBitwiseValues(String name) throws Exception {
        Map<String, Long> map;
        Map<String, Long> bitwiseValues = this._bitwiseValues.get(name);
        if (bitwiseValues != null) {
            return bitwiseValues;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select actionId, bitwiseValue from ResourceAction where name = ?");
            ps.setString(1, name);
            rs = ps.executeQuery();
            bitwiseValues = new HashMap<String, Long>();
            while (rs.next()) {
                String actionId = rs.getString("actionId");
                long bitwiseValue = rs.getLong("bitwiseValue");
                bitwiseValues.put(actionId, bitwiseValue);
            }
            this._bitwiseValues.put(name, bitwiseValues);
            map = bitwiseValues;
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return map;
    }

    protected abstract String getClassName();

    protected long getClassNameId() {
        return PortalUtil.getClassNameId(this.getClassName());
    }

    protected long getContainerModelFolderId(long groupId, long companyId, long resourcePrimKey, long containerModelId, long userId, String userName, Timestamp createDate) throws Exception {
        return 0L;
    }

    protected abstract String getDirName(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getFolderId(long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, long parentFolderId, String name, boolean hidden) throws Exception {
        PreparedStatement ps;
        block3: {
            long l;
            if (repositoryId < 0L || parentFolderId < 0L) {
                return -1L;
            }
            ps = null;
            ResultSet rs = null;
            try {
                ps = this.connection.prepareStatement("select folderId from DLFolder where repositoryId = ? and parentFolderId = ? and name = ?");
                ps.setLong(1, repositoryId);
                ps.setLong(2, parentFolderId);
                ps.setString(3, name);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(ps);
                throw throwable;
            }
            DataAccess.cleanUp(ps);
            return l;
        }
        DataAccess.cleanUp(ps);
        return this.addDLFolder(this.increment(), groupId, companyId, userId, userName, createDate, repositoryId, false, parentFolderId, name, hidden);
    }

    protected abstract String getPortletId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRepositoryId(long groupId, long companyId, long userId, String userName, Timestamp createDate, long classNameId, String portletId) throws Exception {
        PreparedStatement ps;
        block2: {
            long l;
            ps = null;
            ResultSet rs = null;
            try {
                ps = this.connection.prepareStatement("select repositoryId from Repository where groupId = ? and name = ? and portletId = ?");
                ps.setLong(1, groupId);
                ps.setString(2, portletId);
                ps.setString(3, portletId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(ps);
                throw throwable;
            }
            DataAccess.cleanUp(ps);
            return l;
        }
        DataAccess.cleanUp(ps);
        return this.addRepository(groupId, companyId, userId, userName, createDate, classNameId, portletId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRoleId(long companyId, String name) throws Exception {
        long l;
        String roleIdsKey = companyId + "#" + name;
        Long roleId = this._roleIds.get(roleIdsKey);
        if (roleId != null) {
            return roleId;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select roleId from Role_ where companyId = ? and name = ?");
            ps.setLong(1, companyId);
            ps.setString(2, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                roleId = rs.getLong("roleId");
            }
            this._roleIds.put(roleIdsKey, roleId);
            l = roleId;
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return l;
    }

    protected abstract void updateAttachments() throws Exception;

    protected void updateEntryAttachments(long companyId, long groupId, long resourcePrimKey, long containerModelId, long userId, String userName) throws Exception {
        Object[] attachments = this.getAttachments(companyId, containerModelId, resourcePrimKey);
        if (ArrayUtil.isEmpty(attachments)) {
            return;
        }
        Timestamp createDate = new Timestamp(System.currentTimeMillis());
        long repositoryId = this.getRepositoryId(groupId, companyId, userId, userName, createDate, PortalUtil.getClassNameId(_LIFERAY_REPOSITORY_CLASS_NAME), this.getPortletId());
        if (repositoryId < 0L) {
            return;
        }
        long containerModelFolderId = this.getContainerModelFolderId(groupId, companyId, resourcePrimKey, containerModelId, userId, userName, createDate);
        if (containerModelFolderId < 0L) {
            return;
        }
        for (Object attachment : attachments) {
            block8: {
                String name = String.valueOf(this.increment("com.liferay.portlet.documentlibrary.model.DLFileEntry"));
                String title = FileUtil.getShortFileName((String)attachment);
                String extension = FileUtil.getExtension(title);
                String mimeType = MimeTypesUtil.getExtensionContentType(extension);
                try {
                    long size = DLStoreUtil.getFileSize(companyId, 0L, (String)attachment);
                    long fileEntryId = this.addDLFileEntry(groupId, companyId, userId, this.getClassName(), resourcePrimKey, userName, createDate, repositoryId, containerModelFolderId, name, extension, mimeType, title, size);
                    if (fileEntryId < 0L) continue;
                    this.addDLFileVersion(this.increment(), groupId, companyId, userId, userName, createDate, repositoryId, containerModelFolderId, fileEntryId, extension, mimeType, title, size);
                    byte[] bytes = DLStoreUtil.getFileAsBytes(companyId, 0L, (String)attachment);
                    DLStoreUtil.addFile(companyId, containerModelFolderId, name, false, bytes);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn("Unable to add attachment " + (String)attachment, exception);
                }
            }
            try {
                DLStoreUtil.deleteFile(companyId, 0L, (String)attachment);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Unable to delete attachment " + (String)attachment, exception);
            }
        }
    }
}

