/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upload;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadHandler;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.upload.UploadServletRequestConfigurationHelperUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseUploadHandler
implements UploadHandler {
    protected static final String TEMP_FOLDER_NAME = BaseUploadHandler.class.getName();

    @Override
    public void upload(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.checkPermission(themeDisplay.getScopeGroupId(), this.getFolderId(uploadPortletRequest), themeDisplay.getPermissionChecker());
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            UploadException uploadException = (UploadException)portletRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            JSONObject imageJSONObject = this.getImageJSONObject(portletRequest);
            String randomId = ParamUtil.getString(uploadPortletRequest, "randomId");
            imageJSONObject.put("randomId", randomId);
            jsonObject.put("file", imageJSONObject).put("success", Boolean.TRUE);
            JSONPortletResponseUtil.writeJSON(portletRequest, portletResponse, (Object)jsonObject);
        }
        catch (IOException ioException) {
            throw new SystemException(ioException);
        }
        catch (PortalException portalException) {
            this.handleUploadException(portletRequest, portletResponse, portalException, jsonObject);
        }
    }

    protected abstract FileEntry addFileEntry(long var1, long var3, long var5, String var7, String var8, InputStream var9, long var10, ServiceContext var12) throws PortalException;

    protected abstract void checkPermission(long var1, long var3, PermissionChecker var5) throws PortalException;

    protected void doHandleUploadException(PortletRequest portletRequest, PortletResponse portletResponse, PortalException portalException, JSONObject jsonObject) throws PortalException {
        throw portalException;
    }

    protected abstract FileEntry fetchFileEntry(long var1, long var3, long var5, String var7) throws PortalException;

    protected long getFolderId(UploadPortletRequest uploadPortletRequest) {
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONObject getImageJSONObject(PortletRequest portletRequest) throws PortalException {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject imageJSONObject = JSONFactoryUtil.createJSONObject();
        try {
            imageJSONObject.put("attributeDataImageId", "data-image-id");
            String parameterName = this.getParameterName();
            String fileName = uploadPortletRequest.getFileName(parameterName);
            String contentType = uploadPortletRequest.getContentType(parameterName);
            long size = uploadPortletRequest.getSize(parameterName);
            this.validateFile(fileName, contentType, size);
            long folderId = this.getFolderId(uploadPortletRequest);
            String uniqueFileName = this.getUniqueFileName(themeDisplay, fileName, folderId);
            try (InputStream inputStream = uploadPortletRequest.getFileAsStream(parameterName);){
                FileEntry fileEntry = this.addFileEntry(themeDisplay.getUserId(), themeDisplay.getScopeGroupId(), folderId, uniqueFileName, contentType, inputStream, size, this.getServiceContext(uploadPortletRequest));
                imageJSONObject.put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("title", fileEntry.getTitle()).put("type", "document").put("url", this.getURL(fileEntry, themeDisplay)).put("uuid", fileEntry.getUuid());
                JSONObject jSONObject = imageJSONObject;
                return jSONObject;
            }
        }
        catch (IOException ioException) {
            throw new SystemException(ioException);
        }
    }

    protected abstract String getParameterName();

    protected ServiceContext getServiceContext(UploadPortletRequest uploadPortletRequest) throws PortalException {
        return null;
    }

    protected String getUniqueFileName(ThemeDisplay themeDisplay, String fileName, long folderId) throws PortalException {
        FileEntry fileEntry = this.fetchFileEntry(themeDisplay.getUserId(), themeDisplay.getScopeGroupId(), folderId, fileName);
        if (fileEntry == null) {
            return fileName;
        }
        int suffix = 1;
        int i = 0;
        while ((long)i < UploadServletRequestConfigurationHelperUtil.getMaxTries()) {
            String curFileName = FileUtil.appendParentheticalSuffix(fileName, String.valueOf(suffix));
            fileEntry = this.fetchFileEntry(themeDisplay.getUserId(), themeDisplay.getScopeGroupId(), folderId, curFileName);
            if (fileEntry == null) {
                return curFileName;
            }
            ++suffix;
            ++i;
        }
        throw new PortalException("Unable to get a unique file name for " + fileName);
    }

    protected String getURL(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        return PortletFileRepositoryUtil.getPortletFileEntryURL(themeDisplay, fileEntry, "");
    }

    protected void handleUploadException(PortletRequest portletRequest, PortletResponse portletResponse, PortalException portalException, JSONObject jsonObject) throws PortalException {
        jsonObject.put("success", Boolean.FALSE);
        if (portalException instanceof AntivirusScannerException || portalException instanceof FileNameException || portalException instanceof FileSizeException || portalException instanceof UploadRequestSizeException) {
            String errorMessage = "";
            int errorType = 0;
            if (portalException instanceof AntivirusScannerException) {
                errorType = 494;
                AntivirusScannerException antivirusScannerException = (AntivirusScannerException)portalException;
                ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                errorMessage = themeDisplay.translate(antivirusScannerException.getMessageKey());
            } else if (portalException instanceof FileNameException) {
                errorType = 492;
            } else if (portalException instanceof FileSizeException) {
                errorType = 493;
            } else if (portalException instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            jsonObject.put("error", JSONUtil.put("errorType", (Object)errorType).put("message", errorMessage));
        } else {
            this.doHandleUploadException(portletRequest, portletResponse, portalException, jsonObject);
        }
        try {
            JSONPortletResponseUtil.writeJSON(portletRequest, portletResponse, (Object)jsonObject);
        }
        catch (IOException ioException) {
            throw new SystemException(ioException);
        }
    }

    protected abstract void validateFile(String var1, String var2, long var3) throws PortalException;
}

