/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.CollectorOutputProcessor;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;

public class HeapUtil {
    private static final int _PROCESS_ID;
    private static final boolean _SUPPORTED;
    private static final Log _log;

    public static int getProcessId() {
        if (!_SUPPORTED) {
            throw new IllegalStateException(HeapUtil.class.getName() + " does not support the current JVM");
        }
        return _PROCESS_ID;
    }

    public static <O, E> Future<Map.Entry<O, E>> heapDump(boolean live, boolean binary, String file, OutputProcessor<O, E> outputProcessor) {
        return HeapUtil.heapDump(_PROCESS_ID, live, binary, file, outputProcessor);
    }

    public static <O, E> Future<Map.Entry<O, E>> heapDump(int processId, boolean live, boolean binary, String file, OutputProcessor<O, E> outputProcessor) {
        if (!_SUPPORTED) {
            throw new IllegalStateException(HeapUtil.class.getName() + " does not support the current JVM");
        }
        StringBundler sb = new StringBundler(5);
        sb.append("-dump:");
        if (live) {
            sb.append("live,");
        }
        if (binary) {
            sb.append("format=b,");
        }
        sb.append("file=");
        sb.append(file);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("jmap");
        arguments.add(sb.toString());
        arguments.add(String.valueOf(processId));
        try {
            return ProcessUtil.execute(outputProcessor, arguments);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to perform heap dump", exception);
        }
    }

    public static boolean isSupported() {
        return _SUPPORTED;
    }

    private static void _checkJMap(int processId) throws Exception {
        NoticeableFuture future = ProcessUtil.execute((OutputProcessor)CollectorOutputProcessor.INSTANCE, (String[])new String[]{"jmap", "-histo:live", String.valueOf(processId)});
        Map.Entry entry = (Map.Entry)future.get();
        String stdOutString = new String((byte[])entry.getKey());
        if (!stdOutString.contains("#instances")) {
            throw new IllegalStateException("JMap cannot connect to process ID " + processId);
        }
        byte[] stdErrBytes = (byte[])entry.getValue();
        if (stdErrBytes.length != 0) {
            throw new IllegalStateException("JMap returns with error: " + new String(stdErrBytes));
        }
    }

    private static void _checkJPS(int processId) throws Exception {
        NoticeableFuture future = ProcessUtil.execute((OutputProcessor)CollectorOutputProcessor.INSTANCE, (String[])new String[]{"jps"});
        Map.Entry entry = (Map.Entry)future.get();
        String stdOutString = new String((byte[])entry.getKey());
        if (!stdOutString.contains(String.valueOf(processId))) {
            throw new IllegalStateException("JPS cannot detect expected process ID " + processId);
        }
        byte[] stdErrBytes = (byte[])entry.getValue();
        if (stdErrBytes.length != 0) {
            throw new IllegalStateException("JPS returns with error: " + new String(stdErrBytes));
        }
    }

    private static int _getProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeMXBean.getName();
        int index = name.indexOf(64);
        if (index == -1) {
            throw new RuntimeException("Unable to parse process name " + name);
        }
        int pid = GetterUtil.getInteger(name.substring(0, index));
        if (pid == 0) {
            throw new RuntimeException("Unable to parse process name " + name);
        }
        return pid;
    }

    static {
        _log = LogFactoryUtil.getLog(HeapUtil.class);
        int processId = -1;
        boolean supported = false;
        if (JavaDetector.isOracle()) {
            try {
                processId = HeapUtil._getProcessId();
                HeapUtil._checkJPS(processId);
                HeapUtil._checkJMap(processId);
                supported = true;
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn(HeapUtil.class.getName() + " is disabled", exception);
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug(HeapUtil.class.getName() + " is only supported on Oracle JVMs");
        }
        _PROCESS_ID = processId;
        _SUPPORTED = supported;
    }
}

