/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinkedHashMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> LinkedHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        return new LinkedHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>(inputCollection, unsafeFunction);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        return new LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>(key, valueUnsafeSupplier);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(K key, V value) {
        return new LinkedHashMapWrapper<K, V>(key, value);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        return new LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        return new LinkedHashMapWrapper<K, V>(keyUnsafeSupplier, value);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        return new LinkedHashMapWrapper<K, V>(inputMap);
    }

    public static final class LinkedHashMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final LinkedHashMap<K, V> _linkedHashMap = new LinkedHashMap();

        public LinkedHashMapWrapper(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
        }

        public LinkedHashMapWrapper(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
        }

        public LinkedHashMapWrapper(K key, V value) {
            this._linkedHashMap.put(key, value);
        }

        public LinkedHashMapWrapper(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
        }

        public LinkedHashMapWrapper(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
        }

        public LinkedHashMapWrapper(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
        }

        public LinkedHashMap<K, V> build() {
            return this._linkedHashMap;
        }

        public LinkedHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(K key, V value) {
            this._linkedHashMap.put(key, value);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        public LinkedHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
            return this;
        }

        @Override
        protected LinkedHashMap<K, V> getMap() {
            return this._linkedHashMap;
        }
    }
}

