/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.ConcurrentModificationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionClicks {
    private static final String _DEFAULT_NAMESPACE = SessionClicks.class.getName();
    private static final int _SESSION_CLICKS_MAX_ALLOWED_VALUES = GetterUtil.getInteger(PropsUtil.get("session.clicks.max.allowed.values"));
    private static final int _SESSION_CLICKS_MAX_SIZE_TERMS = GetterUtil.getInteger(PropsUtil.get("session.clicks.max.size.terms"));
    private static final Log _log = LogFactoryUtil.getLog(SessionClicks.class);

    public static String get(HttpServletRequest httpServletRequest, String key, String defaultValue) {
        return SessionClicks.get(httpServletRequest, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpServletRequest httpServletRequest, String namespace, String key, String defaultValue) {
        try {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
            return portalPreferences.getValue(namespace, key, defaultValue);
        }
        catch (Exception exception) {
            _log.error(exception, exception);
            return null;
        }
    }

    public static String get(HttpSession session, String key, String defaultValue) {
        return SessionClicks.get(session, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpSession session, String namespace, String key, String defaultValue) {
        String sessionKey = namespace.concat(":").concat(key);
        return GetterUtil.getString(session.getAttribute(sessionKey), defaultValue);
    }

    public static void put(HttpServletRequest httpServletRequest, String key, String value) {
        SessionClicks.put(httpServletRequest, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpServletRequest httpServletRequest, String namespace, String key, String value) {
        if (key.length() > _SESSION_CLICKS_MAX_SIZE_TERMS || value.length() > _SESSION_CLICKS_MAX_SIZE_TERMS) {
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat("Session clicks has attempted to exceed the maximum ", "size allowed for keys or values with {key=", key, ", value=", value, "}"));
            }
            return;
        }
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
                int size = portalPreferences.size();
                if (size <= _SESSION_CLICKS_MAX_ALLOWED_VALUES) {
                    portalPreferences.setValue(namespace, key, value);
                    break;
                }
                if (!_log.isWarnEnabled()) break;
                _log.warn(StringBundler.concat("Session clicks has attempted to exceed the ", "maximum number of allowed values with {key=", key, ", value=", value, "}"));
            }
            catch (ConcurrentModificationException portalPreferences) {
                continue;
            }
            catch (Exception exception) {
                _log.error(exception, exception);
            }
            break;
        }
    }

    public static void put(HttpSession session, String key, String value) {
        SessionClicks.put(session, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpSession session, String namespace, String key, String value) {
        String sessionKey = namespace.concat(":").concat(key);
        session.setAttribute(sessionKey, (Object)value);
    }
}

