/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class TreeMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> TreeMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        return new TreeMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>(inputCollection, unsafeFunction);
    }

    public static <K, V> TreeMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        return new TreeMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>(key, valueUnsafeSupplier);
    }

    public static <K, V> TreeMapWrapper<K, V> put(K key, V value) {
        return new TreeMapWrapper<K, V>(key, value);
    }

    public static <K, V> TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        return new TreeMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        return new TreeMapWrapper<K, V>(keyUnsafeSupplier, value);
    }

    public static <K, V> TreeMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        return new TreeMapWrapper<K, V>(inputMap);
    }

    public static final class TreeMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final TreeMap<K, V> _treeMap = new TreeMap();

        public TreeMapWrapper(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
        }

        public TreeMapWrapper(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
        }

        public TreeMapWrapper(K key, V value) {
            this._treeMap.put(key, value);
        }

        public TreeMapWrapper(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
        }

        public TreeMapWrapper(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
        }

        public TreeMapWrapper(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
        }

        public TreeMap<K, V> build() {
            return this._treeMap;
        }

        public TreeMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public TreeMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public TreeMapWrapper<K, V> put(K key, V value) {
            this._treeMap.put(key, value);
            return this;
        }

        public TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public TreeMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        public TreeMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
            return this;
        }

        @Override
        protected TreeMap<K, V> getMap() {
            return this._treeMap;
        }
    }
}

