/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.model;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.social.kernel.model.SocialAchievement;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityAchievement;
import com.liferay.social.kernel.model.SocialActivityCounter;
import com.liferay.social.kernel.model.SocialActivityCounterDefinition;
import com.liferay.social.kernel.model.SocialActivityDefinition;
import com.liferay.social.kernel.service.SocialActivityAchievementLocalServiceUtil;
import com.liferay.social.kernel.service.SocialActivityCounterLocalServiceUtil;
import java.util.Objects;

public class BaseSocialAchievement
implements SocialAchievement {
    private static final String _ACHIEVEMENT_DESCRIPTION_PREFIX = "social.achievement.description.";
    private static final String _ACHIEVEMENT_NAME_PREFIX = "social.achievement.name.";
    private static final String _ICON_SUFFIX = "-icon.jpg";
    private static final Log _log = LogFactoryUtil.getLog(BaseSocialAchievement.class);
    private int _counterIncrement = 1;
    private String _counterName;
    private String _counterOwner;
    private int _counterPeriodLength = 0;
    private int _counterThreshold;
    private String _icon;
    private String _name;
    private int _ownerType;

    public boolean equals(SocialAchievement socialAchievement) {
        return Objects.equals(this._name, socialAchievement.getName());
    }

    public int getCounterIncrement() {
        return this._counterIncrement;
    }

    public String getCounterName() {
        return this._counterName;
    }

    public String getCounterOwner() {
        return this._counterOwner;
    }

    public int getCounterPeriodLength() {
        return this._counterPeriodLength;
    }

    public int getCounterThreshold() {
        return this._counterThreshold;
    }

    @Override
    public String getDescriptionKey() {
        return _ACHIEVEMENT_DESCRIPTION_PREFIX.concat(this._name);
    }

    @Override
    public String getIcon() {
        if (this._icon == null) {
            return this._name.concat(_ICON_SUFFIX);
        }
        return this._icon;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getNameKey() {
        return _ACHIEVEMENT_NAME_PREFIX.concat(this._name);
    }

    @Override
    public void initialize(SocialActivityDefinition activityDefinition) {
        SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(this._counterName);
        if (activityCounterDefinition != null) {
            return;
        }
        activityCounterDefinition = new SocialActivityCounterDefinition();
        activityCounterDefinition.setEnabled(true);
        activityCounterDefinition.setIncrement(this._counterIncrement);
        activityCounterDefinition.setName(this._counterName);
        activityCounterDefinition.setOwnerType(this._counterOwner);
        if (this._counterPeriodLength > 0) {
            activityCounterDefinition.setPeriodLength(this._counterPeriodLength);
            activityCounterDefinition.setTransient(true);
        }
        activityDefinition.addCounter(activityCounterDefinition);
    }

    @Override
    public void processActivity(SocialActivity activity) {
        block2: {
            try {
                this.doProcessActivity(activity);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Unable to process activity", exception);
            }
        }
    }

    public void setCounterIncrement(int counterIncrement) {
        this._counterIncrement = counterIncrement;
    }

    public void setCounterName(String counterName) {
        this._counterName = counterName;
    }

    public void setCounterOwner(String counterOwner) {
        this._counterOwner = counterOwner;
        if (StringUtil.equalsIgnoreCase(counterOwner, "actor")) {
            this._ownerType = 1;
        } else if (StringUtil.equalsIgnoreCase(counterOwner, "asset")) {
            this._ownerType = 2;
        } else if (StringUtil.equalsIgnoreCase(counterOwner, "creator")) {
            this._ownerType = 3;
        }
    }

    public void setCounterPeriodLength(int counterPeriodLength) {
        this._counterPeriodLength = counterPeriodLength;
    }

    public void setCounterThreshold(int counterThreshold) {
        this._counterThreshold = counterThreshold;
    }

    @Override
    public void setIcon(String icon) {
        this._icon = icon;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this._name = "";
            return;
        }
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            } else if (c == ' ') {
                c = '_';
            } else if (!(c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_')) continue;
            sb.append(c);
        }
        this._name = sb.toString();
    }

    @Override
    public void setProperty(String name, String value) {
        if (name.equals("counterIncrement") || name.equals("counterPeriodLength") || name.equals("counterThreshold")) {
            BeanPropertiesUtil.setProperty(this, name, GetterUtil.getInteger(value));
        } else {
            BeanPropertiesUtil.setProperty(this, name, value);
        }
    }

    protected void doProcessActivity(SocialActivity activity) throws PortalException {
        SocialActivityCounter activityCounter;
        AssetEntry assetEntry;
        if (this._counterThreshold == 0) {
            return;
        }
        SocialActivityAchievement achievement = SocialActivityAchievementLocalServiceUtil.fetchUserAchievement(activity.getUserId(), activity.getGroupId(), this._name);
        if (achievement != null) {
            return;
        }
        long classNameId = activity.getClassNameId();
        long classPK = activity.getClassPK();
        if (this._ownerType != 2) {
            classNameId = PortalUtil.getClassNameId(User.class);
            classPK = activity.getUserId();
        }
        if (this._ownerType == 2 && (assetEntry = AssetEntryLocalServiceUtil.fetchEntry(activity.getClassName(), activity.getClassPK())) != null) {
            classPK = assetEntry.getUserId();
        }
        if ((activityCounter = SocialActivityCounterLocalServiceUtil.fetchLatestActivityCounter(activity.getGroupId(), classNameId, classPK, this._counterName, this._ownerType)) != null && activityCounter.getCurrentValue() >= this._counterThreshold) {
            SocialActivityAchievementLocalServiceUtil.addActivityAchievement(activity.getUserId(), activity.getGroupId(), this);
        }
    }
}

