/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.management;

import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.management.ClusterManageActionWrapper;
import com.liferay.portal.kernel.management.ManageAction;
import com.liferay.portal.kernel.management.ManageActionException;
import com.liferay.portal.kernel.management.PortalManager;
import com.liferay.portal.kernel.model.ClusterGroup;
import com.liferay.portal.kernel.service.ClusterGroupLocalServiceUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.lang.reflect.Method;

public class PortalManagerUtil {
    private static final Method _MANAGE_METHOD;
    private static PortalManager _portalManager;

    public static MethodHandler createManageActionMethodHandler(ManageAction<?> manageAction) {
        return new MethodHandler(_MANAGE_METHOD, manageAction);
    }

    public static PortalManager getPortalManager() {
        return _portalManager;
    }

    public static FutureClusterResponses manage(ClusterGroup clusterGroup, ManageAction<?> manageAction) throws ManageActionException {
        ClusterManageActionWrapper manageActionWrapper = new ClusterManageActionWrapper(clusterGroup, manageAction);
        return PortalManagerUtil.getPortalManager().manage(manageActionWrapper);
    }

    public static <T> T manage(ManageAction<T> manageAction) throws ManageActionException {
        return PortalManagerUtil.getPortalManager().manage(manageAction);
    }

    public static void manageAsync(ClusterNode clusterNode, ManageAction<?> manageAction) throws Exception {
        ClusterGroup clusterGroup = ClusterGroupLocalServiceUtil.createClusterGroup(0L);
        clusterGroup.setClusterNodeIds(clusterNode.getClusterNodeId());
        PortalManagerUtil.manage(clusterGroup, manageAction);
    }

    public static <T> T manageSync(ClusterNode clusterNode, ManageAction<T> manageAction) throws Exception {
        ClusterGroup clusterGroup = ClusterGroupLocalServiceUtil.createClusterGroup(0L);
        clusterGroup.setClusterNodeIds(clusterNode.getClusterNodeId());
        FutureClusterResponses futureClusterResponses = PortalManagerUtil.manage(clusterGroup, manageAction);
        ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get();
        ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
        return (T)clusterNodeResponse.getResult();
    }

    public void setPortalManager(PortalManager portalManager) {
        _portalManager = portalManager;
    }

    static {
        try {
            _MANAGE_METHOD = PortalManagerUtil.class.getDeclaredMethod("manage", ManageAction.class);
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError(e);
        }
    }
}

