/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.LayoutQueryStringComposite;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

@OSGiBeanProperties(service={FriendlyURLResolver.class})
public class VirtualLayoutFriendlyURLResolver
implements FriendlyURLResolver {
    @Override
    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String groupFriendlyURL = null;
        int pos = friendlyURL.indexOf(47, 3);
        if (pos != -1) {
            groupFriendlyURL = friendlyURL.substring(2, pos);
        }
        if (Validator.isNull(groupFriendlyURL)) {
            return mainPath;
        }
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, groupFriendlyURL);
        if (group == null) {
            return mainPath;
        }
        String layoutFriendlyURL = null;
        if (pos != -1 && pos + 1 != friendlyURL.length()) {
            layoutFriendlyURL = friendlyURL.substring(pos);
        }
        if (Validator.isNull(layoutFriendlyURL)) {
            return mainPath;
        }
        String actualURL = PortalUtil.getActualURL(group.getGroupId(), privateLayout, mainPath, layoutFriendlyURL, params, requestContext);
        return HttpUtil.addParameter(HttpUtil.removeParameter(actualURL, "p_v_l_s_g_id"), "p_v_l_s_g_id", groupId);
    }

    @Override
    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String groupFriendlyURL = null;
        int pos = friendlyURL.indexOf(47, 3);
        if (pos != -1) {
            groupFriendlyURL = friendlyURL.substring(2, pos);
        }
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, groupFriendlyURL);
        String layoutFriendlyURL = null;
        if (pos != -1 && pos + 1 != friendlyURL.length()) {
            layoutFriendlyURL = friendlyURL.substring(pos);
        }
        LayoutQueryStringComposite layoutQueryStringComposite = PortalUtil.getActualLayoutQueryStringComposite(group.getGroupId(), privateLayout, layoutFriendlyURL, params, requestContext);
        return new LayoutFriendlyURLComposite(layoutQueryStringComposite.getLayout(), layoutFriendlyURL);
    }

    @Override
    public LayoutFriendlyURLSeparatorComposite getLayoutFriendlyURLSeparatorComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLComposite layoutFriendlyURLComposite = this.getLayoutFriendlyURLComposite(companyId, groupId, privateLayout, friendlyURL, params, requestContext);
        return new LayoutFriendlyURLSeparatorComposite(layoutFriendlyURLComposite, "/-/");
    }

    @Override
    public String getURLSeparator() {
        return "/~";
    }
}

