/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.generic;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BaseBooleanQueryImpl;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanClauseOccurImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.generic.BooleanClauseImpl;
import com.liferay.portal.kernel.search.generic.QueryTermImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.TermRangeQueryImpl;
import com.liferay.portal.kernel.search.query.FieldQueryFactoryUtil;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BooleanQueryImpl
extends BaseBooleanQueryImpl {
    private final List<BooleanClause<Query>> _booleanClauses = new ArrayList<BooleanClause<Query>>();

    @Override
    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return queryVisitor.visitQuery(this);
    }

    @Override
    public Query add(Query query, BooleanClauseOccur booleanClauseOccur) {
        if (query == null) {
            throw new IllegalArgumentException("Query is null");
        }
        this._booleanClauses.add(new BooleanClauseImpl<Query>(query, booleanClauseOccur));
        return query;
    }

    @Override
    public Query add(Query query, String occur) {
        BooleanClauseOccurImpl booleanClauseOccur = new BooleanClauseOccurImpl(occur);
        this.add(query, booleanClauseOccur);
        return query;
    }

    @Override
    public Query addExactTerm(String field, boolean value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, Boolean value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, double value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, Double value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, int value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, Integer value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, long value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, Long value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, short value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, Short value) {
        return this.addExactTerm(field, String.valueOf(value));
    }

    @Override
    public Query addExactTerm(String field, String value) {
        TermQueryImpl termQuery = new TermQueryImpl(new QueryTermImpl(field, String.valueOf(value)));
        return this.add((Query)termQuery, BooleanClauseOccur.SHOULD);
    }

    @Override
    public Collection<Query> addNumericRangeTerm(String field, int startValue, int endValue) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (int i = startValue; i <= endValue; ++i) {
            Query query = this.addExactTerm(field, i);
            queries.add(query);
        }
        return queries;
    }

    @Override
    public Collection<Query> addNumericRangeTerm(String field, Integer startValue, Integer endValue) {
        return this.addNumericRangeTerm(field, (int)startValue, (int)endValue);
    }

    @Override
    public Collection<Query> addNumericRangeTerm(String field, long startValue, long endValue) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (long i = startValue; i <= endValue; ++i) {
            Query query = this.addExactTerm(field, i);
            queries.add(query);
        }
        return queries;
    }

    @Override
    public Collection<Query> addNumericRangeTerm(String field, Long startValue, Long endValue) {
        return this.addNumericRangeTerm(field, (long)startValue, (long)endValue);
    }

    @Override
    public Collection<Query> addNumericRangeTerm(String field, short startValue, short endValue) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (short i = startValue; i <= endValue; i = (short)(i + 1)) {
            Query query = this.addExactTerm(field, i);
            queries.add(query);
        }
        return queries;
    }

    @Override
    public Collection<Query> addNumericRangeTerm(String field, Short startValue, Short endValue) {
        return this.addNumericRangeTerm(field, (short)startValue, (short)endValue);
    }

    @Override
    public Query addRangeTerm(String field, int startValue, int endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, String.valueOf(startValue), String.valueOf(endValue), true, true);
        return this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    @Override
    public Query addRangeTerm(String field, Integer startValue, Integer endValue) {
        return this.addRangeTerm(field, (int)startValue, (int)endValue);
    }

    @Override
    public Query addRangeTerm(String field, long startValue, long endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, String.valueOf(startValue), String.valueOf(endValue), true, true);
        return this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    @Override
    public Query addRangeTerm(String field, Long startValue, Long endValue) {
        return this.addRangeTerm(field, (long)startValue, (long)endValue);
    }

    @Override
    public Query addRangeTerm(String field, short startValue, short endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, String.valueOf(startValue), String.valueOf(endValue), true, true);
        return this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    @Override
    public Query addRangeTerm(String field, Short startValue, Short endValue) {
        return this.addRangeTerm(field, (short)startValue, (short)endValue);
    }

    @Override
    public Query addRangeTerm(String field, String startValue, String endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, startValue, endValue, true, true);
        return this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    @Override
    public Query addRequiredTerm(String field, boolean value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, Boolean value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, double value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, Double value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, int value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, Integer value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, long value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, Long value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, short value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, Short value) {
        return this.addRequiredTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addRequiredTerm(String field, String value) {
        return this.addRequiredTerm(field, value, false);
    }

    @Override
    public Query addRequiredTerm(String field, String value, boolean like) {
        return this.addRequiredTerm(field, value, like, false);
    }

    public Query addRequiredTerm(String field, String value, boolean like, boolean parseKeywords) {
        Query query = FieldQueryFactoryUtil.createQuery(field, value, like, parseKeywords);
        return this.add(query, BooleanClauseOccur.MUST);
    }

    @Override
    public Query addTerm(String field, long value) {
        return this.addTerm(field, String.valueOf(value), false);
    }

    @Override
    public Query addTerm(String field, String value) {
        return this.addTerm(field, value, false);
    }

    @Override
    public Query addTerm(String field, String value, boolean like) {
        return this.addTerm(field, value, like, BooleanClauseOccur.SHOULD);
    }

    public Query addTerm(String field, String value, boolean like, boolean parseKeywords) {
        Query query = FieldQueryFactoryUtil.createQuery(field, value, like, parseKeywords);
        return this.add(query, BooleanClauseOccur.SHOULD);
    }

    @Override
    public Query addTerm(String field, String value, boolean like, BooleanClauseOccur booleanClauseOccur) {
        Query query = FieldQueryFactoryUtil.createQuery(field, value, like, false);
        return this.add(query, booleanClauseOccur);
    }

    @Override
    public List<BooleanClause<Query>> clauses() {
        return Collections.unmodifiableList(this._booleanClauses);
    }

    @Override
    public boolean hasChildren() {
        return this.hasClauses();
    }

    @Override
    public boolean hasClauses() {
        return !this._booleanClauses.isEmpty();
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{booleanClauses=");
        sb.append(this._booleanClauses);
        sb.append(", className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append("}");
        return sb.toString();
    }
}

