/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import java.util.Objects;
import java.util.function.ToLongFunction;

public class StagedModelPermissionLogic<T extends GroupedModel>
implements ModelResourcePermissionLogic<T> {
    private final String _portletId;
    private final ToLongFunction<T> _primKeyToLongFunction;
    private final StagingPermission _stagingPermission;

    public StagedModelPermissionLogic(StagingPermission stagingPermission, String portletId, ToLongFunction<T> primKeyToLongFunction) {
        this._stagingPermission = Objects.requireNonNull(stagingPermission);
        this._portletId = Objects.requireNonNull(portletId);
        this._primKeyToLongFunction = Objects.requireNonNull(primKeyToLongFunction);
    }

    @Override
    public Boolean contains(PermissionChecker permissionChecker, String name, T model, String actionId) {
        return this._stagingPermission.hasPermission(permissionChecker, model.getGroupId(), name, this._primKeyToLongFunction.applyAsLong(model), this._portletId, actionId);
    }
}

