/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class BaseRelatedEntryIndexer
implements RelatedEntryIndexer {
    @Override
    public void addRelatedClassNames(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        searchContext.setAttribute("relatedClassName", Boolean.TRUE);
        Object[] relatedEntryClassNames = (String[])searchContext.getAttribute("relatedEntryClassNames");
        if (ArrayUtil.isEmpty(relatedEntryClassNames)) {
            return;
        }
        BooleanFilter relatedBooleanFilters = new BooleanFilter();
        for (Object relatedEntryClassName : relatedEntryClassNames) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)relatedEntryClassName);
            if (indexer == null) continue;
            BooleanFilter relatedBooleanFilter = new BooleanFilter();
            indexer.postProcessContextBooleanFilter(relatedBooleanFilter, searchContext);
            for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                indexerPostProcessor.postProcessContextBooleanFilter(relatedBooleanFilter, searchContext);
            }
            this.postProcessContextQuery(relatedBooleanFilter, searchContext, indexer);
            relatedBooleanFilter.addRequiredTerm("classNameId", PortalUtil.getClassNameId((String)relatedEntryClassName));
            relatedBooleanFilters.add(relatedBooleanFilter, BooleanClauseOccur.SHOULD);
        }
        if (relatedBooleanFilters.hasClauses()) {
            contextBooleanFilter.add(relatedBooleanFilters, BooleanClauseOccur.MUST);
        }
        searchContext.setAttribute("relatedClassName", Boolean.FALSE);
    }

    @Override
    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
    }

    @Override
    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        return true;
    }

    @Override
    public void updateFullQuery(SearchContext searchContext) {
    }

    @Deprecated
    protected void postProcessContextQuery(BooleanFilter relatedBooleanFilter, SearchContext searchContext, Indexer<?> indexer) throws Exception {
        BooleanQueryImpl entityQuery = new BooleanQueryImpl();
        indexer.postProcessContextQuery(entityQuery, searchContext);
        if (entityQuery.hasClauses()) {
            QueryFilter queryFilter = new QueryFilter(entityQuery);
            relatedBooleanFilter.add(queryFilter, BooleanClauseOccur.MUST);
        }
    }
}

