/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AggregateResourceBundleLoader
implements ResourceBundleLoader {
    private final ResourceBundleLoader[] _resourceBundleLoaders;

    public AggregateResourceBundleLoader(ResourceBundleLoader ... resourceBundleLoaders) {
        for (int i = 0; i < resourceBundleLoaders.length; ++i) {
            if (resourceBundleLoaders[i] != null) continue;
            throw new NullPointerException("Null resource bundle loader at index " + i);
        }
        this._resourceBundleLoaders = resourceBundleLoaders;
    }

    @Override
    public ResourceBundle loadResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (ResourceBundleLoader resourceBundleLoader : this._resourceBundleLoaders) {
            try {
                ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
                if (resourceBundle == null) continue;
                resourceBundles.add(resourceBundle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundles.isEmpty()) {
            String languageId = LocaleUtil.toLanguageId(locale);
            throw new MissingResourceException(StringBundler.concat("Resource bundle loader ", String.valueOf(this), " was unable to load resource bundle for ", languageId), "", languageId);
        }
        if (resourceBundles.size() == 1) {
            return (ResourceBundle)resourceBundles.get(0);
        }
        return new AggregateResourceBundle(resourceBundles.toArray(new ResourceBundle[0]));
    }

    @Override
    @Deprecated
    public ResourceBundle loadResourceBundle(String languageId) {
        return ResourceBundleLoader.super.loadResourceBundle(languageId);
    }
}

