/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import java.util.Objects;

public class JavaDetector {
    private static final String _JAVA_VERSION_JDK_7 = "1.7.";
    private static final String _JAVA_VERSION_JDK_8 = "1.8.";
    private static final String _JAVA_VERSION_JDK_11 = "11";
    private static final Log _log = LogFactoryUtil.getLog(JavaDetector.class);
    private static final JavaDetector _instance = new JavaDetector();
    private final boolean _64bit;
    private final boolean _ibm;
    private final String _javaClassPath = System.getProperty("java.class.path");
    private final double _javaClassVersion = GetterUtil.getDouble(System.getProperty("java.class.version"));
    private final String _javaRuntimeName = System.getProperty("java.runtime.name");
    private final String _javaRuntimeVersion = System.getProperty("java.runtime.version");
    private final double _javaSpecificationVersion = GetterUtil.getDouble(System.getProperty("java.specification.version"));
    private final String _javaVendor = System.getProperty("java.vendor");
    private final String _javaVersion = System.getProperty("java.version");
    private final String _javaVmVersion = System.getProperty("java.vm.version");
    private final boolean _openJDK;
    private final boolean _oracle;

    public static String getJavaClassPath() {
        return JavaDetector._instance._javaClassPath;
    }

    public static double getJavaClassVersion() {
        return JavaDetector._instance._javaClassVersion;
    }

    public static String getJavaRuntimeName() {
        return JavaDetector._instance._javaRuntimeName;
    }

    public static String getJavaRuntimeVersion() {
        return JavaDetector._instance._javaRuntimeVersion;
    }

    public static double getJavaSpecificationVersion() {
        return JavaDetector._instance._javaSpecificationVersion;
    }

    public static String getJavaVendor() {
        return JavaDetector._instance._javaVendor;
    }

    public static String getJavaVersion() {
        return JavaDetector._instance._javaVersion;
    }

    public static String getJavaVmVersion() {
        return JavaDetector._instance._javaVmVersion;
    }

    public static boolean is64bit() {
        return JavaDetector._instance._64bit;
    }

    public static boolean isIBM() {
        return JavaDetector._instance._ibm;
    }

    public static boolean isJDK7() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_7);
    }

    public static boolean isJDK8() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_8);
    }

    public static boolean isJDK11() {
        String javaVersion = JavaDetector.getJavaVersion();
        return javaVersion.startsWith(_JAVA_VERSION_JDK_11);
    }

    public static boolean isOpenJDK() {
        return JavaDetector._instance._openJDK;
    }

    public static boolean isOracle() {
        return JavaDetector._instance._oracle;
    }

    protected JavaDetector() {
        this._64bit = Objects.equals(System.getProperty("sun.arch.data.model"), "64");
        boolean oracle = false;
        if (this._javaVendor != null) {
            this._ibm = this._javaVendor.startsWith("IBM");
            if (this._javaVendor.startsWith("Oracle") || this._javaVendor.startsWith("Sun")) {
                oracle = true;
            }
        } else {
            this._ibm = false;
        }
        this._oracle = oracle;
        this._openJDK = this._javaRuntimeName != null ? this._javaRuntimeName.contains("OpenJDK") : false;
        if (_log.isDebugEnabled()) {
            LogUtil.debug(_log, new SortedProperties(System.getProperties()));
        }
    }
}

