/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedList;

public class LimitedFIFOQueue<E>
extends AbstractQueue<E> {
    private final int _capacity;
    private final LinkedList<E> _linkedList = new LinkedList();

    public LimitedFIFOQueue(int capacity) {
        this._capacity = capacity;
    }

    @Override
    public Iterator<E> iterator() {
        return this._linkedList.iterator();
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this._capacity) {
            this._linkedList.removeFirst();
        }
        this._linkedList.offerLast(e);
        return true;
    }

    @Override
    public E peek() {
        return this._linkedList.peek();
    }

    @Override
    public E poll() {
        return this._linkedList.poll();
    }

    @Override
    public int size() {
        return this._linkedList.size();
    }
}

