/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth.http;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpAuthorizationHeader {
    public static final String AUTH_PARAMETER_NAME_NONCE = "nonce";
    public static final String AUTH_PARAMETER_NAME_PASSWORD = "password";
    public static final String AUTH_PARAMETER_NAME_REALM = "realm";
    public static final String AUTH_PARAMETER_NAME_RESPONSE = "response";
    public static final String AUTH_PARAMETER_NAME_URI = "uri";
    public static final String AUTH_PARAMETER_NAME_USERNAME = "username";
    public static final String SCHEME_BASIC = "Basic";
    public static final String SCHEME_DIGEST = "Digest";
    private final Map<String, String> _authParameters = new LinkedHashMap<String, String>();
    private String _scheme;

    public HttpAuthorizationHeader(String scheme) {
        this._scheme = scheme;
    }

    public String getAuthParameter(String name) {
        return this._authParameters.get(name);
    }

    public Map<String, String> getAuthParameters() {
        return this._authParameters;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setAuthParameter(String name, String value) {
        this._authParameters.put(name, value);
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public String toString() {
        if (this._scheme.equals(SCHEME_BASIC) && !Validator.isBlank(this.getAuthParameter(AUTH_PARAMETER_NAME_USERNAME))) {
            String userName = this.getAuthParameter(AUTH_PARAMETER_NAME_USERNAME);
            String password = this.getAuthParameter(AUTH_PARAMETER_NAME_PASSWORD);
            String userNameAndPassword = userName + ":" + password;
            String encodedUserNameAndPassword = Base64.encode(userNameAndPassword.getBytes());
            return "Basic " + encodedUserNameAndPassword;
        }
        StringBundler sb = new StringBundler(this._authParameters.size() * 6 + 2);
        sb.append(this._scheme);
        sb.append(" ");
        for (Map.Entry<String, String> entry : this._authParameters.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

