/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib.ui;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.taglib.ui.BaseFormNavigatorEntry;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorEntry;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPFormNavigatorEntry<T>
extends BaseFormNavigatorEntry<T>
implements FormNavigatorEntry<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPFormNavigatorEntry.class);
    private ServletContext _servletContext;

    @Override
    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServletContext servletContext = this.getServletContext(httpServletRequest);
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(this.getJspPath());
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ServletException se) {
            _log.error("Unable to include JSP " + this.getJspPath(), se);
            throw new IOException("Unable to include " + this.getJspPath(), se);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected abstract String getJspPath();

    protected ServletContext getServletContext(HttpServletRequest httpServletRequest) {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        String portletId = PortalUtil.getPortletId(httpServletRequest);
        if (Validator.isNotNull(portletId)) {
            String rootPortletId = PortletIdCodec.decodePortletName(portletId);
            PortletBag portletBag = PortletBagPool.get(rootPortletId);
            return portletBag.getServletContext();
        }
        return (ServletContext)httpServletRequest.getAttribute("CTX");
    }
}

