/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.BaseModifiableSettings;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesSettings
extends BaseModifiableSettings {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesSettings.class);
    private final PortletPreferences _portletPreferences;

    public PortletPreferencesSettings(PortletPreferences portletPreferences) {
        this(portletPreferences, null);
    }

    public PortletPreferencesSettings(PortletPreferences portletPreferences, Settings parentSettings) {
        super(parentSettings);
        this._portletPreferences = portletPreferences;
    }

    @Override
    public Collection<String> getModifiedKeys() {
        HashSet<String> keys = new HashSet<String>();
        Enumeration names = this._portletPreferences.getNames();
        while (names.hasMoreElements()) {
            keys.add((String)names.nextElement());
        }
        return keys;
    }

    public PortletPreferences getPortletPreferences() {
        return this._portletPreferences;
    }

    @Override
    public void reset(String key) {
        try {
            this._portletPreferences.reset(key);
        }
        catch (ReadOnlyException roe) {
            _log.error("Portlet preferences used to persist settings should never be read only", roe);
        }
    }

    @Override
    public ModifiableSettings setValue(String key, String value) {
        try {
            this._portletPreferences.setValue(key, value);
        }
        catch (ReadOnlyException roe) {
            _log.error("Portlet preferences used to persist settings should never be read only", roe);
        }
        return this;
    }

    @Override
    public ModifiableSettings setValues(String key, String[] values) {
        try {
            this._portletPreferences.setValues(key, values);
        }
        catch (ReadOnlyException roe) {
            _log.error("Portlet preferences used to persist settings should never be read only", roe);
        }
        return this;
    }

    @Override
    public void store() throws IOException, ValidatorException {
        this._portletPreferences.store();
    }

    @Override
    protected String doGetValue(String key) {
        return this._portletPreferences.getValue(key, null);
    }

    @Override
    protected String[] doGetValues(String key) {
        return this._portletPreferences.getValues(key, null);
    }
}

