/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletPreferences;

public abstract class BasePortletLayoutFinder
implements PortletLayoutFinder {
    private static final Log _log = LogFactoryUtil.getLog(BasePortletLayoutFinder.class);

    @Override
    public PortletLayoutFinder.Result find(ThemeDisplay themeDisplay, long groupId) throws PortalException {
        String[] portletIds;
        block7: {
            portletIds = this.getPortletIds();
            if (themeDisplay.getPlid() != 0L && groupId == themeDisplay.getScopeGroupId()) {
                try {
                    Layout layout = LayoutLocalServiceUtil.getLayout(themeDisplay.getPlid());
                    LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                    for (String portletId : portletIds) {
                        if (!layoutTypePortlet.hasPortletId(portletId, false) || !LayoutPermissionUtil.contains(themeDisplay.getPermissionChecker(), layout, "VIEW")) continue;
                        portletId = this.getPortletId(layoutTypePortlet, portletId);
                        return new ResultImpl(themeDisplay.getPlid(), portletId);
                    }
                }
                catch (NoSuchLayoutException nsle) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug(nsle, nsle);
                }
            }
        }
        Object[] plidAndPortletId = this.fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), groupId, portletIds);
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (plidAndPortletId == null && (scopeGroup.isSite() || SitesUtil.isUserGroupLayoutSetViewable(themeDisplay.getPermissionChecker(), scopeGroup))) {
            plidAndPortletId = this.fetchPlidAndPortletId(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletIds);
        }
        if (plidAndPortletId != null) {
            return new ResultImpl((Long)plidAndPortletId[0], (String)plidAndPortletId[1]);
        }
        StringBundler sb = new StringBundler(portletIds.length * 2 + 5);
        sb.append("{groupId=");
        sb.append(groupId);
        sb.append(", plid=");
        sb.append(themeDisplay.getPlid());
        for (String portletId : portletIds) {
            sb.append(", portletId=");
            sb.append(portletId);
        }
        sb.append("}");
        throw new NoSuchLayoutException(sb.toString());
    }

    protected Object[] fetchPlidAndPortletId(PermissionChecker permissionChecker, long groupId, String[] portletIds) throws PortalException {
        for (String portletId : portletIds) {
            Layout layout;
            ObjectValuePair<Long, String> plidAndPortletIdObjectValuePair = this._getPlidPortletIdObjectValuePair(groupId, portletId);
            long plid = plidAndPortletIdObjectValuePair.getKey();
            if (plid == 0L || !LayoutPermissionUtil.contains(permissionChecker, layout = LayoutLocalServiceUtil.getLayout(plid), "VIEW")) continue;
            return new Object[]{plid, plidAndPortletIdObjectValuePair.getValue()};
        }
        return null;
    }

    protected String getPortletId(LayoutTypePortlet layoutTypePortlet, String portletId) {
        for (String curPortletId : layoutTypePortlet.getPortletIds()) {
            String curRootPortletId = PortletIdCodec.decodePortletName(curPortletId);
            if (!portletId.equals(curRootPortletId)) continue;
            return curPortletId;
        }
        return null;
    }

    protected abstract String[] getPortletIds();

    private ObjectValuePair<Long, String> _getPlidPortletIdObjectValuePair(long groupId, long scopeGroupId, String portletId) throws PortalException {
        for (boolean privateLayout : Arrays.asList(false, true)) {
            List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, "portlet");
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                String candidatePortletId = this.getPortletId(layoutTypePortlet, portletId);
                if (!Validator.isNotNull(candidatePortletId) || this._getScopeGroupId(layout, candidatePortletId) != scopeGroupId) continue;
                return new ObjectValuePair<Long, String>(layout.getPlid(), candidatePortletId);
            }
        }
        return new ObjectValuePair<Long, String>(0L, "");
    }

    private ObjectValuePair<Long, String> _getPlidPortletIdObjectValuePair(long scopeGroupId, String portletId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup(scopeGroupId);
        long groupId = group.getGroupId();
        if (group.isLayout()) {
            Layout scopeLayout = LayoutLocalServiceUtil.getLayout(group.getClassPK());
            groupId = scopeLayout.getGroupId();
        }
        return this._getPlidPortletIdObjectValuePair(groupId, scopeGroupId, portletId);
    }

    private long _getScopeGroupId(Layout layout, String portletId) throws PortalException {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup(layout, portletId);
        String scopeType = GetterUtil.getString(portletSetup.getValue("lfrScopeType", null));
        if (Validator.isNull(scopeType)) {
            return layout.getGroupId();
        }
        if (scopeType.equals("company")) {
            Group companyGroup = GroupLocalServiceUtil.getCompanyGroup(layout.getCompanyId());
            return companyGroup.getGroupId();
        }
        String scopeLayoutUuid = GetterUtil.getString(portletSetup.getValue("lfrScopeLayoutUuid", null));
        Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId(scopeLayoutUuid, layout.getGroupId(), layout.isPrivateLayout());
        Group scopeGroup = scopeLayout.getScopeGroup();
        return scopeGroup.getGroupId();
    }

    protected class ResultImpl
    implements PortletLayoutFinder.Result {
        private final long _plid;
        private final String _portletId;

        public ResultImpl(long plid, String portletId) {
            this._plid = plid;
            this._portletId = portletId;
        }

        @Override
        public long getPlid() {
            return this._plid;
        }

        @Override
        public String getPortletId() {
            return this._portletId;
        }
    }
}

