/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClearTimerThreadUtil {
    private static final Method _CLEAR_METHOD;
    private static final boolean _INITIALIZED;
    private static final Field _NEW_TASKS_MAY_BE_SCHEDULED_FIELD;
    private static final Field _QUEUE_FIELD;
    private static final Log _log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTimerThread() throws Exception {
        Thread[] threads;
        if (!_INITIALIZED) {
            return;
        }
        for (Thread thread : threads = ThreadUtil.getThreads()) {
            Object queue;
            Class<?> threadClass;
            String threadClassName;
            if (thread == null || !(threadClassName = (threadClass = thread.getClass()).getName()).equals("java.util.TimerThread")) continue;
            Object object = queue = _QUEUE_FIELD.get(thread);
            synchronized (object) {
                _NEW_TASKS_MAY_BE_SCHEDULED_FIELD.setBoolean(thread, false);
                _CLEAR_METHOD.invoke(queue, new Object[0]);
                queue.notify();
            }
        }
    }

    static {
        boolean initialized;
        Field queueField;
        Field newTasksMayBeScheduledField;
        Method clearMethod;
        block2: {
            _log = LogFactoryUtil.getLog(ClearTimerThreadUtil.class);
            clearMethod = null;
            newTasksMayBeScheduledField = null;
            queueField = null;
            initialized = false;
            try {
                Class<?> taskQueueClass = Class.forName("java.util.TaskQueue");
                clearMethod = ReflectionUtil.getDeclaredMethod(taskQueueClass, (String)"clear", (Class[])new Class[0]);
                Class<?> timeThreadClass = Class.forName("java.util.TimerThread");
                newTasksMayBeScheduledField = ReflectionUtil.getDeclaredField(timeThreadClass, (String)"newTasksMayBeScheduled");
                queueField = ReflectionUtil.getDeclaredField(timeThreadClass, (String)"queue");
                initialized = true;
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Failed to initialize ClearTimerThreadUtil");
            }
        }
        _CLEAR_METHOD = clearMethod;
        _NEW_TASKS_MAY_BE_SCHEDULED_FIELD = newTasksMayBeScheduledField;
        _QUEUE_FIELD = queueField;
        _INITIALIZED = initialized;
    }
}

