/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.announcements.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.UserBagFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class AnnouncementsUtil {
    private static final long _GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId(Group.class.getName());
    private static final long _ORGANIZATION_CLASS_NAME_ID = PortalUtil.getClassNameId(Organization.class.getName());
    private static final boolean _PERMISSIONS_CHECK_GUEST_ENABLED = GetterUtil.getBoolean(PropsUtil.get("permissions.check.guest.enabled"));
    private static final long _ROLE_CLASS_NAME_ID = PortalUtil.getClassNameId(Role.class.getName());
    private static final long _USER_CLASS_NAME_ID = PortalUtil.getClassNameId(User.class.getName());
    private static final long _USER_GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId(UserGroup.class.getName());

    public static LinkedHashMap<Long, long[]> getAnnouncementScopes(User user) throws PortalException {
        List<UserGroup> userGroups;
        long[] groupIds;
        long userId = user.getUserId();
        LinkedHashMap<Long, long[]> scopes = LinkedHashMapBuilder.put(Long.valueOf(0L), new long[]{0L}).put((Long)_USER_CLASS_NAME_ID, new long[]{userId}).build();
        UserBag userBag = UserBagFactoryUtil.create(userId);
        long[] organizationIds = userBag.getUserOrgIds();
        if (organizationIds.length > 0) {
            scopes.put(_ORGANIZATION_CLASS_NAME_ID, organizationIds);
        }
        if ((groupIds = userBag.getUserGroupIds()).length > 0) {
            scopes.put(_GROUP_CLASS_NAME_ID, groupIds);
        }
        if (!(userGroups = UserGroupLocalServiceUtil.getUserUserGroups(userId)).isEmpty()) {
            long[] userGroupIds = ListUtil.toLongArray(userGroups, UserGroup.USER_GROUP_ID_ACCESSOR);
            scopes.put(_USER_GROUP_CLASS_NAME_ID, userGroupIds);
        }
        Set<Long> roleIds = SetUtil.fromArray(userBag.getRoleIds());
        if (groupIds.length > 0 || organizationIds.length > 0) {
            List<UserGroupRole> userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles(userId);
            for (UserGroupRole userGroupRole : userGroupRoles) {
                roleIds.add(userGroupRole.getRoleId());
            }
        }
        if (!userGroups.isEmpty()) {
            List<UserGroupGroupRole> userGroupGroupRoles = UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRolesByUser(userId);
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                roleIds.add(userGroupGroupRole.getRoleId());
            }
        }
        List<Team> teams = TeamLocalServiceUtil.getUserTeams(userId);
        long[] teamIds = ListUtil.toLongArray(teams, Team.TEAM_ID_ACCESSOR);
        long companyId = user.getCompanyId();
        if (teamIds.length > 0) {
            List<Role> teamsRoles = RoleLocalServiceUtil.getTeamsRoles(companyId, teamIds);
            for (Role teamRole : teamsRoles) {
                roleIds.add(teamRole.getRoleId());
            }
        }
        if (_PERMISSIONS_CHECK_GUEST_ENABLED) {
            Role guestRole = RoleLocalServiceUtil.getRole(companyId, "Guest");
            roleIds.add(guestRole.getRoleId());
        }
        if (!roleIds.isEmpty()) {
            scopes.put(_ROLE_CLASS_NAME_ID, ArrayUtil.toLongArray(roleIds));
        }
        return scopes;
    }

    public static List<Group> getGroups(ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        List<Group> groups = GroupLocalServiceUtil.getUserGroups(themeDisplay.getUserId(), true);
        for (Group group : groups) {
            if ((!group.isOrganization() || !group.isSite()) && !group.isRegularSite() || !GroupPermissionUtil.contains(themeDisplay.getPermissionChecker(), group.getGroupId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public static List<Organization> getOrganizations(ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<Organization> filteredOrganizations = new ArrayList<Organization>();
        List<Organization> organizations = OrganizationLocalServiceUtil.getUserOrganizations(themeDisplay.getUserId());
        for (Organization organization : organizations) {
            if (!OrganizationPermissionUtil.contains(themeDisplay.getPermissionChecker(), organization.getOrganizationId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredOrganizations.add(organization);
        }
        return filteredOrganizations;
    }

    public static List<Role> getRoles(ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<Role> filteredRoles = new ArrayList<Role>();
        List<Role> roles = RoleLocalServiceUtil.getRoles(themeDisplay.getCompanyId());
        for (Role role : roles) {
            if (!AnnouncementsUtil.hasManageAnnouncementsPermission(role, themeDisplay.getPermissionChecker())) continue;
            filteredRoles.add(role);
        }
        return filteredRoles;
    }

    public static List<UserGroup> getUserGroups(ThemeDisplay themeDisplay) {
        ArrayList<UserGroup> filteredUserGroups = new ArrayList<UserGroup>();
        List<UserGroup> userGroups = UserGroupLocalServiceUtil.getUserGroups(themeDisplay.getCompanyId());
        for (UserGroup userGroup : userGroups) {
            if (!UserGroupPermissionUtil.contains(themeDisplay.getPermissionChecker(), userGroup.getUserGroupId(), "MANAGE_ANNOUNCEMENTS")) continue;
            filteredUserGroups.add(userGroup);
        }
        return filteredUserGroups;
    }

    public static boolean hasManageAnnouncementsPermission(Role role, PermissionChecker permissionChecker) throws PortalException {
        Team team;
        return role.isTeam() ? GroupPermissionUtil.contains(permissionChecker, (team = TeamLocalServiceUtil.getTeam(role.getClassPK())).getGroupId(), "MANAGE_ANNOUNCEMENTS") && RolePermissionUtil.contains(permissionChecker, team.getGroupId(), role.getRoleId(), "MANAGE_ANNOUNCEMENTS") : RolePermissionUtil.contains(permissionChecker, role.getRoleId(), "MANAGE_ANNOUNCEMENTS");
    }
}

