/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;

public class AssetRendererFactoryRegistryUtil {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, AssetRendererFactory<?>> _classNameAssetRenderFactoriesServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, AssetRendererFactory.class, null, (serviceReference, emitter) -> {
        AssetRendererFactory assetRendererFactory = (AssetRendererFactory)_bundleContext.getService(serviceReference);
        emitter.emit((Object)assetRendererFactory.getClassName());
    });
    private static final ServiceTrackerMap<String, AssetRendererFactory<?>> _typeAssetRenderFactoriesServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, AssetRendererFactory.class, null, (serviceReference, emitter) -> {
        AssetRendererFactory assetRendererFactory = (AssetRendererFactory)_bundleContext.getService(serviceReference);
        emitter.emit((Object)assetRendererFactory.getType());
    });

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId) {
        return ListUtil.fromMapValues(AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, _classNameAssetRenderFactoriesServiceTrackerMap, false));
    }

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId, boolean filterSelectable) {
        return ListUtil.fromMapValues(AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, _classNameAssetRenderFactoriesServiceTrackerMap, filterSelectable));
    }

    public static <T> AssetRendererFactory<T> getAssetRendererFactoryByClass(Class<T> clazz) {
        return (AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)clazz.getName());
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByClassName(String className) {
        return (AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)className);
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByClassNameId(long classNameId) {
        return (AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)PortalUtil.getClassName(classNameId));
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByType(String type) {
        return (AssetRendererFactory)_typeAssetRenderFactoriesServiceTrackerMap.getService((Object)type);
    }

    public static long[] getClassNameIds(long companyId) {
        return AssetRendererFactoryRegistryUtil.getClassNameIds(companyId, false);
    }

    public static long[] getClassNameIds(long companyId, boolean filterSelectable) {
        if (companyId > 0L) {
            Map<String, AssetRendererFactory<?>> assetRenderFactories = AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, _classNameAssetRenderFactoriesServiceTrackerMap, filterSelectable);
            long[] classNameIds = new long[assetRenderFactories.size()];
            int i = 0;
            for (AssetRendererFactory<?> assetRendererFactory : assetRenderFactories.values()) {
                classNameIds[i] = assetRendererFactory.getClassNameId();
                ++i;
            }
            return classNameIds;
        }
        Set classNames = _classNameAssetRenderFactoriesServiceTrackerMap.keySet();
        Stream stream = classNames.stream();
        return stream.map(arg_0 -> _classNameAssetRenderFactoriesServiceTrackerMap.getService(arg_0)).map(AssetRendererFactory::getClassNameId).mapToLong(classNameId -> classNameId).toArray();
    }

    private static Map<String, AssetRendererFactory<?>> _filterAssetRendererFactories(long companyId, ServiceTrackerMap<String, AssetRendererFactory<?>> assetRendererFactories, boolean filterSelectable) {
        ConcurrentHashMap filteredAssetRendererFactories = new ConcurrentHashMap();
        for (String key : assetRendererFactories.keySet()) {
            AssetRendererFactory assetRendererFactory = (AssetRendererFactory)assetRendererFactories.getService((Object)key);
            if (!assetRendererFactory.isActive(companyId) || filterSelectable && !assetRendererFactory.isSelectable()) continue;
            filteredAssetRendererFactories.put(key, assetRendererFactory);
        }
        return filteredAssetRendererFactories;
    }

    private AssetRendererFactoryRegistryUtil() {
    }
}

