/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel.model;

import com.liferay.asset.kernel.NoSuchClassTypeFieldException;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.LocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DDMStructureClassType
implements ClassType {
    private static final String[] _SELECTABLE_DDM_STRUCTURE_FIELDS = new String[]{"checkbox", "checkbox_multiple", "date", "ddm-date", "ddm-decimal", "ddm-image", "ddm-integer", "ddm-number", "ddm-text-html", "image", "numeric", "radio", "rich_text", "select", "text", "textarea"};
    private final long _classTypeId;
    private final String _classTypeName;
    private final String _languageId;

    public DDMStructureClassType(long classTypeId, String classTypeName, String languageId) {
        this._classTypeId = classTypeId;
        this._classTypeName = classTypeName;
        this._languageId = languageId;
    }

    @Override
    public ClassTypeField getClassTypeField(String fieldName) throws PortalException {
        for (ClassTypeField classTypeField : this.getClassTypeFields()) {
            if (!fieldName.equals(classTypeField.getName())) continue;
            return classTypeField;
        }
        throw new NoSuchClassTypeFieldException();
    }

    @Override
    public List<ClassTypeField> getClassTypeFields() throws PortalException {
        return this.getClassTypeFields(this.getClassTypeId());
    }

    @Override
    public List<ClassTypeField> getClassTypeFields(int start, int end) throws PortalException {
        return ListUtil.subList(this.getClassTypeFields(), start, end);
    }

    @Override
    public int getClassTypeFieldsCount() throws PortalException {
        return this.getClassTypeFields().size();
    }

    @Override
    public long getClassTypeId() {
        return this._classTypeId;
    }

    @Override
    public String getName() {
        return this._classTypeName;
    }

    protected List<ClassTypeField> getClassTypeFields(long ddmStructureId) throws PortalException {
        ArrayList<ClassTypeField> classTypeFields = new ArrayList<ClassTypeField>();
        DDMStructure ddmStructure = DDMStructureManagerUtil.getStructure(ddmStructureId);
        List<DDMFormField> ddmFormFields = ddmStructure.getDDMFormFields(false);
        for (DDMFormField ddmFormField : ddmFormFields) {
            String indexType = ddmFormField.getIndexType();
            String type = ddmFormField.getType();
            if (Validator.isNull(indexType) || Objects.equals(indexType, "none") || !ArrayUtil.contains(_SELECTABLE_DDM_STRUCTURE_FIELDS, type)) continue;
            LocalizedValue label = ddmFormField.getLabel();
            classTypeFields.add(new ClassTypeField(ddmStructure.getStructureId(), ddmFormField.getFieldReference(), label.getString(LocaleUtil.fromLanguageId(this._languageId)), ddmFormField.getName(), type));
        }
        return classTypeFields;
    }
}

