/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.exception;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import java.util.Locale;

public class InvalidFolderException
extends PortalException {
    public static final int CANNOT_MOVE_INTO_CHILD_FOLDER = 1;
    public static final int CANNOT_MOVE_INTO_ITSELF = 2;
    private static final Log _log = LogFactoryUtil.getLog(InvalidFolderException.class);
    private final long _folderId;
    private final int _type;

    public InvalidFolderException(int type, long folderId) {
        this._type = type;
        this._folderId = folderId;
    }

    public long getFolderId() {
        return this._folderId;
    }

    public String getMessageArgument(Locale locale) {
        try {
            if (this._folderId == 0L) {
                return LanguageUtil.get(locale, "home");
            }
            Folder folder = DLAppLocalServiceUtil.getFolder(this._folderId);
            return folder.getName();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn(portalException);
            }
            return "";
        }
    }

    public String getMessageKey() {
        if (this._type == 1) {
            return "unable-to-move-folder-x-into-one-of-its-children";
        }
        if (this._type == 2) {
            return "unable-to-move-folder-x-into-itself";
        }
        return null;
    }
}

