/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.store;

import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.transaction.Transactional;
import java.io.File;
import java.io.InputStream;
import org.osgi.annotation.versioning.ProviderType;

@Transactional(rollbackFor={PortalException.class, SystemException.class})
@ProviderType
public interface DLStore {
    default public void addFile(DLStoreRequest dlStoreRequest, byte[] bytes) throws PortalException {
        this.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.isValidateFileExtension(), bytes);
    }

    default public void addFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        this.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.isValidateFileExtension(), file);
    }

    default public void addFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        this.addFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.isValidateFileExtension(), inputStream);
    }

    public void addFile(long var1, long var3, String var5, boolean var6, byte[] var7) throws PortalException;

    public void addFile(long var1, long var3, String var5, boolean var6, File var7) throws PortalException;

    public void addFile(long var1, long var3, String var5, boolean var6, InputStream var7) throws PortalException;

    public void addFile(long var1, long var3, String var5, byte[] var6) throws PortalException;

    public void addFile(long var1, long var3, String var5, File var6) throws PortalException;

    public void addFile(long var1, long var3, String var5, InputStream var6) throws PortalException;

    public void copyFileVersion(long var1, long var3, String var5, String var6, String var7) throws PortalException;

    public void deleteDirectory(long var1, long var3, String var5);

    public void deleteFile(long var1, long var3, String var5) throws PortalException;

    public void deleteFile(long var1, long var3, String var5, String var6) throws PortalException;

    public byte[] getFileAsBytes(long var1, long var3, String var5) throws PortalException;

    public byte[] getFileAsBytes(long var1, long var3, String var5, String var6) throws PortalException;

    public InputStream getFileAsStream(long var1, long var3, String var5) throws PortalException;

    public InputStream getFileAsStream(long var1, long var3, String var5, String var6) throws PortalException;

    public String[] getFileNames(long var1, long var3, String var5) throws PortalException;

    public long getFileSize(long var1, long var3, String var5) throws PortalException;

    public boolean hasFile(long var1, long var3, String var5) throws PortalException;

    public boolean hasFile(long var1, long var3, String var5, String var6) throws PortalException;

    default public void updateFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        this.updateFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.isValidateFileExtension(), dlStoreRequest.getVersionLabel(), dlStoreRequest.getSourceFileName(), file);
    }

    default public void updateFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        this.updateFile(dlStoreRequest.getCompanyId(), dlStoreRequest.getRepositoryId(), dlStoreRequest.getFileName(), dlStoreRequest.getFileExtension(), dlStoreRequest.isValidateFileExtension(), dlStoreRequest.getVersionLabel(), dlStoreRequest.getSourceFileName(), inputStream);
    }

    public void updateFile(long var1, long var3, long var5, String var7) throws PortalException;

    public void updateFile(long var1, long var3, String var5, String var6, boolean var7, String var8, String var9, File var10) throws PortalException;

    public void updateFile(long var1, long var3, String var5, String var6, boolean var7, String var8, String var9, InputStream var10) throws PortalException;

    public void updateFileVersion(long var1, long var3, String var5, String var6, String var7) throws PortalException;

    public void validate(String var1, boolean var2) throws PortalException;

    public void validate(String var1, boolean var2, byte[] var3) throws PortalException;

    public void validate(String var1, boolean var2, File var3) throws PortalException;

    public void validate(String var1, boolean var2, InputStream var3) throws PortalException;

    public void validate(String var1, String var2, String var3, boolean var4) throws PortalException;

    public void validate(String var1, String var2, String var3, boolean var4, File var5) throws PortalException;

    public void validate(String var1, String var2, String var3, boolean var4, InputStream var5) throws PortalException;
}

