/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.thread.local;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalCache<T> {
    private Map<String, T> _cache;
    private final Object _id;
    private final Lifecycle _lifecycle;

    public ThreadLocalCache(Object id, Lifecycle lifecycle) {
        this._id = id;
        this._lifecycle = lifecycle;
    }

    public T get(String key) {
        if (this._cache == null) {
            return null;
        }
        return this._cache.get(key);
    }

    public Object getId() {
        return this._id;
    }

    public Lifecycle getLifecycle() {
        return this._lifecycle;
    }

    public void put(String key, T object) {
        if (this._cache == null) {
            this._cache = new HashMap<String, T>();
        }
        this._cache.put(key, object);
    }

    public void remove(String key) {
        if (this._cache != null) {
            this._cache.remove(key);
        }
    }

    public void removeAll() {
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{cache=", this._cache.toString(), ", id=", this._id, ", lifecycle=", this._lifecycle, "}"});
    }
}

