/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cookies;

import com.liferay.portal.kernel.cookies.ConsentCookieType;
import com.liferay.portal.kernel.cookies.CookiesManager;
import com.liferay.portal.kernel.cookies.UnsupportedCookieException;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookiesManagerUtil {
    private static volatile CookiesManager _cookiesManager = ServiceProxyFactory.newServiceTrackedInstance(CookiesManager.class, CookiesManagerUtil.class, "_cookiesManager", false);

    public static boolean addCookie(int consentType, Cookie cookie, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return _cookiesManager.addCookie(consentType, cookie, httpServletRequest, httpServletResponse);
    }

    public static boolean addCookie(int consentType, Cookie cookie, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean secure) {
        return _cookiesManager.addCookie(consentType, cookie, httpServletRequest, httpServletResponse, secure);
    }

    public static boolean addSupportCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return _cookiesManager.addSupportCookie(httpServletRequest, httpServletResponse);
    }

    public static boolean deleteCookies(String domain, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String ... cookieNames) {
        return _cookiesManager.deleteCookies(domain, httpServletRequest, httpServletResponse, cookieNames);
    }

    public static String getCookieValue(String cookieName, HttpServletRequest httpServletRequest) {
        return _cookiesManager.getCookieValue(cookieName, httpServletRequest);
    }

    public static String getCookieValue(String cookieName, HttpServletRequest httpServletRequest, boolean toUpperCase) {
        return _cookiesManager.getCookieValue(cookieName, httpServletRequest, toUpperCase);
    }

    public static String getDomain(HttpServletRequest httpServletRequest) {
        return _cookiesManager.getDomain(httpServletRequest);
    }

    public static String getDomain(String host) {
        return _cookiesManager.getDomain(host);
    }

    public static List<ConsentCookieType> getOptionalConsentCookieTypes(long groupId) throws Exception {
        return _cookiesManager.getOptionalConsentCookieTypes(groupId);
    }

    public static List<ConsentCookieType> getRequiredConsentCookieTypes(long groupId) throws Exception {
        return _cookiesManager.getRequiredConsentCookieTypes(groupId);
    }

    public static boolean hasConsentType(int consentType, HttpServletRequest httpServletRequest) {
        return _cookiesManager.hasConsentType(consentType, httpServletRequest);
    }

    public static boolean hasSessionId(HttpServletRequest httpServletRequest) {
        return _cookiesManager.hasSessionId(httpServletRequest);
    }

    public static boolean isEncodedCookie(String cookieName) {
        return _cookiesManager.isEncodedCookie(cookieName);
    }

    public static void validateSupportCookie(HttpServletRequest httpServletRequest) throws UnsupportedCookieException {
        _cookiesManager.validateSupportCookie(httpServletRequest);
    }
}

