/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcess;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class BaseDBProcess
implements DBProcess {
    protected Connection connection;
    private static final Log _log = LogFactoryUtil.getLog(BaseDBProcess.class);

    @Override
    public void runSQL(Connection connection, String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        db.runSQL(connection, template);
    }

    @Override
    public void runSQL(DBTypeToSQLMap dbTypeToSQLMap) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(dbTypeToSQLMap);
        } else {
            db.runSQL(this.connection, dbTypeToSQLMap);
        }
    }

    @Override
    public void runSQL(String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(template);
        } else {
            db.runSQL(this.connection, template);
        }
    }

    @Override
    public void runSQL(String[] templates) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(templates);
        } else {
            db.runSQL(this.connection, templates);
        }
    }

    @Override
    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        this.runSQLTemplate(path, true);
    }

    @Override
    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer(path);){
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + path);
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream(path);
            }
            if (inputStream == null) {
                Thread currentThread = Thread.currentThread();
                classLoader = currentThread.getContextClassLoader();
                inputStream = classLoader.getResourceAsStream(path);
            }
            if (inputStream == null) {
                _log.error("Invalid path " + path);
                if (failOnError) {
                    throw new IOException("Invalid path " + path);
                }
                return;
            }
            String template = StringUtil.read(inputStream);
            this.runSQLTemplateString(template, failOnError);
        }
    }

    @Override
    public void runSQLTemplateString(String template, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DB db = DBManagerUtil.getDB();
            if (this.connection == null) {
                db.runSQLTemplateString(template, failOnError);
            } else {
                db.runSQLTemplateString(this.connection, template, failOnError);
            }
        }
    }

    protected void addIndexes(Connection connection, List<IndexMetadata> indexMetadatas) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        db.addIndexes(connection, indexMetadatas);
    }

    protected void alterColumnName(String tableName, String oldColumnName, String newColumnDefinition) throws Exception {
        String newColumnName = StringUtil.extractFirst(newColumnDefinition, " ");
        String newColumnType = newColumnDefinition.substring(newColumnName.length() + 1);
        if (!this.hasColumn(tableName, oldColumnName)) {
            if (this.hasColumnType(tableName, newColumnName, newColumnType)) {
                return;
            }
            throw new SQLException(StringBundler.concat((String[])new String[]{"Column ", tableName, ".", oldColumnName, " does not exist"}));
        }
        if (this.hasColumnType(tableName, oldColumnName, newColumnType)) {
            DBInspector dbInspector = new DBInspector(this.connection);
            if (StringUtil.equals(dbInspector.normalizeName(oldColumnName), dbInspector.normalizeName(newColumnName))) {
                return;
            }
        } else {
            throw new SQLException(StringBundler.concat((String[])new String[]{"Type change is not allowed when altering column name. ", "Column ", tableName, ".", oldColumnName, " has different type than ", newColumnType}));
        }
        DB db = DBManagerUtil.getDB();
        db.alterColumnName(this.connection, tableName, oldColumnName, newColumnDefinition);
    }

    protected void alterColumnType(String tableName, String columnName, String newColumnType) throws Exception {
        if (!this.hasColumn(tableName, columnName)) {
            throw new SQLException(StringBundler.concat((String[])new String[]{"Column ", tableName, ".", columnName, " does not exist"}));
        }
        if (!this.hasColumnType(tableName, columnName, newColumnType)) {
            DB db = DBManagerUtil.getDB();
            db.alterColumnType(this.connection, tableName, columnName, newColumnType);
        }
    }

    protected void alterTableAddColumn(String tableName, String columnName, String columnType) throws Exception {
        if (this.hasColumn(tableName, columnName)) {
            if (!this.hasColumnType(tableName, columnName, columnType)) {
                throw new SQLException(StringBundler.concat((String[])new String[]{"Column ", tableName, ".", columnName, " already exists with different type than ", columnType}));
            }
            return;
        }
        DB db = DBManagerUtil.getDB();
        db.alterTableAddColumn(this.connection, tableName, columnName, columnType);
    }

    protected void alterTableDropColumn(String tableName, String columnName) throws Exception {
        if (this.hasColumn(tableName, columnName)) {
            DB db = DBManagerUtil.getDB();
            db.alterTableDropColumn(this.connection, tableName, columnName);
        }
    }

    protected void alterTableName(String tableName, String newTableName) throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"alter_table_name ", tableName, " ", newTableName}));
    }

    @Deprecated
    protected boolean doHasTable(String tableName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasTable(tableName, true);
    }

    protected List<IndexMetadata> dropIndexes(String tableName, String columnName) throws Exception {
        DB db = DBManagerUtil.getDB();
        return db.dropIndexes(this.connection, tableName, columnName);
    }

    protected void dropTable(String tableName) throws Exception {
        this.runSQL("DROP_TABLE_IF_EXISTS(" + tableName + ")");
    }

    protected Connection getConnection() throws Exception {
        if (GetterUtil.getBoolean(PropsUtil.get("database.partition.enabled")) && GetterUtil.getBoolean(PropsUtil.get("database.partition.thread.pool.enabled"), true)) {
            return (Connection)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Connection.class}, new ConnectionThreadProxyInvocationHandler());
        }
        return this._getConnection();
    }

    protected String[] getPrimaryKeyColumnNames(Connection connection, String tableName) throws SQLException {
        DB db = DBManagerUtil.getDB();
        return db.getPrimaryKeyColumnNames(connection, tableName);
    }

    protected boolean hasColumn(String tableName, String columnName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumn(tableName, columnName);
    }

    protected boolean hasColumnType(String tableName, String columnName, String columnType) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumnType(tableName, columnName, columnType);
    }

    protected boolean hasIndex(String tableName, String indexName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasIndex(tableName, indexName);
    }

    protected boolean hasRows(Connection connection, String tableName) {
        DBInspector dbInspector = new DBInspector(connection);
        return dbInspector.hasRows(tableName);
    }

    protected boolean hasRows(String tableName) throws Exception {
        return this.hasRows(this.connection, tableName);
    }

    protected boolean hasTable(String tableName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasTable(tableName);
    }

    protected void process(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        DB db = DBManagerUtil.getDB();
        db.process(unsafeConsumer);
    }

    protected void processConcurrently(String sqlQuery, UnsafeFunction<ResultSet, Object[], Exception> unsafeFunction, UnsafeConsumer<Object[], Exception> unsafeConsumer, String exceptionMessage) throws Exception {
        int fetchSize = GetterUtil.getInteger(PropsUtil.get("upgrade.concurrent.fetch.size"));
        try (Statement statement = this.connection.createStatement();){
            statement.setFetchSize(fetchSize);
            try (ResultSet resultSet = statement.executeQuery(sqlQuery);){
                this._processConcurrently(() -> {
                    if (resultSet.next()) {
                        return (Object[])unsafeFunction.apply((Object)resultSet);
                    }
                    return null;
                }, unsafeConsumer, exceptionMessage);
            }
        }
    }

    protected <T> void processConcurrently(T[] array, UnsafeConsumer<T, Exception> unsafeConsumer, String exceptionMessage) throws Exception {
        AtomicInteger atomicInteger = new AtomicInteger();
        this._processConcurrently(() -> {
            int index = atomicInteger.getAndIncrement();
            if (index < array.length) {
                return array[index];
            }
            return null;
        }, unsafeConsumer, exceptionMessage);
    }

    protected void removePrimaryKey(String tableName) throws Exception {
        DB db = DBManagerUtil.getDB();
        db.removePrimaryKey(this.connection, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection _getConnection() {
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            if (bundle == null) return DataAccess.getConnection();
            BundleContext bundleContext = bundle.getBundleContext();
            Collection serviceReferences = bundleContext.getServiceReferences(DataSource.class, StringBundler.concat((String[])new String[]{"(origin.bundle.symbolic.name=", bundle.getSymbolicName(), ")"}));
            Iterator iterator = serviceReferences.iterator();
            if (!iterator.hasNext()) return DataAccess.getConnection();
            ServiceReference serviceReference = (ServiceReference)iterator.next();
            DataSource dataSource = (DataSource)bundleContext.getService(serviceReference);
            try {
                if (dataSource == null) return DataAccess.getConnection();
                Connection connection = dataSource.getConnection();
                return connection;
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        catch (Exception exception) {
            return (Connection)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void _processConcurrently(UnsafeSupplier<T, Exception> unsafeSupplier, UnsafeConsumer<T, Exception> unsafeConsumer, String exceptionMessage) throws Exception {
        Objects.requireNonNull(unsafeSupplier);
        Objects.requireNonNull(unsafeConsumer);
        ExecutorService executorService = Executors.newWorkStealingPool();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            boolean notificationEnabled = NotificationThreadLocal.isEnabled();
            boolean bl = WorkflowThreadLocal.isEnabled();
            long companyId = CompanyThreadLocal.getCompanyId();
            Object next = null;
            while ((next = unsafeSupplier.get()) != null) {
                Object current = next;
                Future<Void> future = executorService.submit(() -> {
                    NotificationThreadLocal.setEnabled(notificationEnabled);
                    WorkflowThreadLocal.setEnabled(workflowEnabled);
                    try (SafeCloseable safeCloseable = CompanyThreadLocal.lock(companyId);){
                        unsafeConsumer.accept(current);
                    }
                    catch (Exception exception) {
                        throwableCollector.collect(exception);
                    }
                    return null;
                });
                int futuresMaxSize = GetterUtil.getInteger(PropsUtil.get("upgrade.concurrent.process.list.max.size"));
                if (futures.size() >= futuresMaxSize) {
                    for (Future future2 : futures) {
                        future2.get();
                    }
                    futures.clear();
                }
                futures.add(future);
            }
        }
        finally {
            executorService.shutdown();
            for (Future future : futures) {
                future.get();
            }
        }
        Throwable throwable = throwableCollector.getThrowable();
        if (throwable != null) {
            if (exceptionMessage != null) {
                throw new Exception(exceptionMessage, throwable);
            }
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    private class ConnectionThreadProxyInvocationHandler
    implements InvocationHandler {
        private final Map<Thread, Connection> _connectionMap = new ConcurrentHashMap<Thread, Connection>();

        private ConnectionThreadProxyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("close")) {
                Collection<Connection> connections = this._connectionMap.values();
                Iterator<Connection> iterator = connections.iterator();
                while (iterator.hasNext()) {
                    Connection connection = iterator.next();
                    iterator.remove();
                    method.invoke((Object)connection, args);
                }
                return null;
            }
            return method.invoke((Object)this._connectionMap.computeIfAbsent(Thread.currentThread(), thread -> BaseDBProcess.this._getConnection()), args);
        }
    }
}

